/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.impl;

import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.util.URLEncodingUtil;
import io.openbpm.bpm.engine.variable.type.ValueType;
import io.openbpm.bpm.engine.variable.value.BytesValue;
import io.openbpm.bpm.engine.variable.value.FileValue;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;

public class VariableResponseProvider {
    public Response getResponseForTypedVariable(TypedValue typedVariableValue, String id) {
        if (typedVariableValue instanceof BytesValue || ValueType.BYTES.equals(typedVariableValue.getType())) {
            return this.responseForByteVariable(typedVariableValue);
        }
        if (ValueType.FILE.equals(typedVariableValue.getType())) {
            return this.responseForFileVariable((FileValue)typedVariableValue);
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Value of variable with id %s is not a binary value.".formatted(id));
    }

    protected Response responseForFileVariable(FileValue fileValue) {
        Object type;
        Object object = type = fileValue.getMimeType() != null ? fileValue.getMimeType() : "application/octet-stream";
        if (fileValue.getEncoding() != null) {
            type = (String)type + "; charset=" + fileValue.getEncoding();
        }
        Object value = fileValue.getValue() == null ? "" : fileValue.getValue();
        return Response.ok((Object)value, (String)type).header("Content-Disposition", (Object)URLEncodingUtil.buildAttachmentValue(fileValue.getFilename())).build();
    }

    protected Response responseForByteVariable(TypedValue variableInstance) {
        byte[] valueBytes = (byte[])variableInstance.getValue();
        if (valueBytes == null) {
            valueBytes = new byte[]{};
        }
        return Response.ok((Object)new ByteArrayInputStream(valueBytes), (String)"application/octet-stream").build();
    }
}

