/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.repository.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.AuthorizationException;
import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.FormService;
import io.openbpm.bpm.engine.ManagementService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.RepositoryService;
import io.openbpm.bpm.engine.RuntimeService;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.exception.NullValueException;
import io.openbpm.bpm.engine.form.FormData;
import io.openbpm.bpm.engine.form.OperatonFormRef;
import io.openbpm.bpm.engine.form.StartFormData;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.form.validator.FormFieldValidationException;
import io.openbpm.bpm.engine.impl.util.IoUtil;
import io.openbpm.bpm.engine.management.ActivityStatistics;
import io.openbpm.bpm.engine.management.ActivityStatisticsQuery;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import io.openbpm.bpm.engine.rest.dto.HistoryTimeToLiveDto;
import io.openbpm.bpm.engine.rest.dto.StatisticsResultDto;
import io.openbpm.bpm.engine.rest.dto.VariableValueDto;
import io.openbpm.bpm.engine.rest.dto.batch.BatchDto;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.bpm.engine.rest.dto.repository.ActivityStatisticsResultDto;
import io.openbpm.bpm.engine.rest.dto.repository.CalledProcessDefinitionDto;
import io.openbpm.bpm.engine.rest.dto.repository.ProcessDefinitionDiagramDto;
import io.openbpm.bpm.engine.rest.dto.repository.ProcessDefinitionDto;
import io.openbpm.bpm.engine.rest.dto.repository.ProcessDefinitionSuspensionStateDto;
import io.openbpm.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import io.openbpm.bpm.engine.rest.dto.runtime.ProcessInstanceWithVariablesDto;
import io.openbpm.bpm.engine.rest.dto.runtime.RestartProcessInstanceDto;
import io.openbpm.bpm.engine.rest.dto.runtime.StartProcessInstanceDto;
import io.openbpm.bpm.engine.rest.dto.runtime.modification.ProcessInstanceModificationInstructionDto;
import io.openbpm.bpm.engine.rest.dto.task.FormDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.exception.RestException;
import io.openbpm.bpm.engine.rest.sub.repository.ProcessDefinitionResource;
import io.openbpm.bpm.engine.rest.util.ApplicationContextPathUtil;
import io.openbpm.bpm.engine.rest.util.ContentTypeUtil;
import io.openbpm.bpm.engine.rest.util.EncodingUtil;
import io.openbpm.bpm.engine.rest.util.URLEncodingUtil;
import io.openbpm.bpm.engine.runtime.InstantiationBuilder;
import io.openbpm.bpm.engine.runtime.ProcessInstance;
import io.openbpm.bpm.engine.runtime.ProcessInstanceWithVariables;
import io.openbpm.bpm.engine.runtime.ProcessInstantiationBuilder;
import io.openbpm.bpm.engine.runtime.RestartProcessInstanceBuilder;
import io.openbpm.bpm.engine.variable.VariableMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProcessDefinitionResourceImpl
implements ProcessDefinitionResource {
    public static final String MSG_CANNOT_INSTANTIATE_PROCESS_DEF = "Cannot instantiate process definition %s: %s";
    protected ProcessEngine engine;
    protected String processDefinitionId;
    protected String rootResourcePath;
    protected ObjectMapper objectMapper;

    public ProcessDefinitionResourceImpl(ProcessEngine engine, String processDefinitionId, String rootResourcePath, ObjectMapper objectMapper) {
        this.engine = engine;
        this.processDefinitionId = processDefinitionId;
        this.rootResourcePath = rootResourcePath;
        this.objectMapper = objectMapper;
    }

    @Override
    public ProcessDefinitionDto getProcessDefinition() {
        ProcessDefinition definition;
        RepositoryService repoService = this.engine.getRepositoryService();
        try {
            definition = repoService.getProcessDefinition(this.processDefinitionId);
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "No matching definition with id " + this.processDefinitionId);
        }
        return ProcessDefinitionDto.fromProcessDefinition(definition);
    }

    @Override
    public Response deleteProcessDefinition(boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        RepositoryService repositoryService = this.engine.getRepositoryService();
        try {
            repositoryService.deleteProcessDefinition(this.processDefinitionId, cascade, skipCustomListeners, skipIoMappings);
        }
        catch (NotFoundException nfe) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)nfe), nfe.getMessage());
        }
        return Response.ok().build();
    }

    @Override
    public ProcessInstanceDto startProcessInstance(UriInfo context, StartProcessInstanceDto parameters) {
        ProcessInstanceWithVariables instance;
        try {
            instance = this.startProcessInstanceAtActivities(parameters);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            String errorMessage = MSG_CANNOT_INSTANTIATE_PROCESS_DEF.formatted(this.processDefinitionId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        catch (RestException e) {
            String errorMessage = MSG_CANNOT_INSTANTIATE_PROCESS_DEF.formatted(this.processDefinitionId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        ProcessInstanceDto result = parameters.isWithVariablesInReturn() ? ProcessInstanceWithVariablesDto.fromProcessInstance(instance) : ProcessInstanceDto.fromProcessInstance((ProcessInstance)instance);
        URI uri = context.getBaseUriBuilder().path(this.rootResourcePath).path("/process-instance").path(instance.getId()).build(new Object[0]);
        result.addReflexiveLink(uri, "GET", "self");
        return result;
    }

    protected ProcessInstanceWithVariables startProcessInstanceAtActivities(StartProcessInstanceDto dto) {
        VariableMap processInstanceVariables = VariableValueDto.toMap(dto.getVariables(), this.engine, this.objectMapper);
        String businessKey = dto.getBusinessKey();
        String caseInstanceId = dto.getCaseInstanceId();
        ProcessInstantiationBuilder instantiationBuilder = (ProcessInstantiationBuilder)this.engine.getRuntimeService().createProcessInstanceById(this.processDefinitionId).businessKey(businessKey).caseInstanceId(caseInstanceId).setVariables((Map)processInstanceVariables);
        if (dto.getStartInstructions() != null && !dto.getStartInstructions().isEmpty()) {
            for (ProcessInstanceModificationInstructionDto instruction : dto.getStartInstructions()) {
                instruction.applyTo((InstantiationBuilder<?>)instantiationBuilder, this.engine, this.objectMapper);
            }
        }
        return instantiationBuilder.executeWithVariablesInReturn(dto.isSkipCustomListeners(), dto.isSkipIoMappings());
    }

    @Override
    public ProcessInstanceDto submitForm(UriInfo context, StartProcessInstanceDto parameters) {
        ProcessInstance instance;
        FormService formService = this.engine.getFormService();
        try {
            VariableMap variables = VariableValueDto.toMap(parameters.getVariables(), this.engine, this.objectMapper);
            String businessKey = parameters.getBusinessKey();
            instance = businessKey != null ? formService.submitStartForm(this.processDefinitionId, businessKey, (Map)variables) : formService.submitStartForm(this.processDefinitionId, (Map)variables);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (FormFieldValidationException e) {
            String errorMessage = MSG_CANNOT_INSTANTIATE_PROCESS_DEF.formatted(this.processDefinitionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), errorMessage);
        }
        catch (ProcessEngineException e) {
            String errorMessage = MSG_CANNOT_INSTANTIATE_PROCESS_DEF.formatted(this.processDefinitionId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        catch (RestException e) {
            String errorMessage = MSG_CANNOT_INSTANTIATE_PROCESS_DEF.formatted(this.processDefinitionId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        ProcessInstanceDto result = ProcessInstanceDto.fromProcessInstance(instance);
        URI uri = context.getBaseUriBuilder().path(this.rootResourcePath).path("/process-instance").path(instance.getId()).build(new Object[0]);
        result.addReflexiveLink(uri, "GET", "self");
        return result;
    }

    @Override
    public List<StatisticsResultDto> getActivityStatistics(Boolean includeFailedJobs, Boolean includeIncidents, String includeIncidentsForType) {
        if (includeIncidents != null && includeIncidentsForType != null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only one of the query parameter includeIncidents or includeIncidentsForType can be set.");
        }
        ManagementService mgmtService = this.engine.getManagementService();
        ActivityStatisticsQuery query = mgmtService.createActivityStatisticsQuery(this.processDefinitionId);
        if (includeFailedJobs != null && includeFailedJobs.booleanValue()) {
            query.includeFailedJobs();
        }
        if (includeIncidents != null && includeIncidents.booleanValue()) {
            query.includeIncidents();
        } else if (includeIncidentsForType != null) {
            query.includeIncidentsForType(includeIncidentsForType);
        }
        List queryResults = query.unlimitedList();
        ArrayList<StatisticsResultDto> results = new ArrayList<StatisticsResultDto>();
        for (ActivityStatistics queryResult : queryResults) {
            ActivityStatisticsResultDto dto = ActivityStatisticsResultDto.fromActivityStatistics(queryResult);
            results.add(dto);
        }
        return results;
    }

    @Override
    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20Xml() {
        ProcessDefinitionDiagramDto processDefinitionDiagramDto;
        InputStream processModelIn = null;
        try {
            processModelIn = this.engine.getRepositoryService().getProcessModel(this.processDefinitionId);
            byte[] processModel = IoUtil.readInputStream((InputStream)processModelIn, (String)"processModelBpmn20Xml");
            processDefinitionDiagramDto = ProcessDefinitionDiagramDto.create(this.processDefinitionId, new String(processModel, StandardCharsets.UTF_8));
        }
        catch (NotFoundException e) {
            try {
                throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "No matching definition with id " + this.processDefinitionId);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(processModelIn);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)processModelIn);
        return processDefinitionDiagramDto;
    }

    @Override
    public Response getProcessDefinitionDiagram() {
        ProcessDefinition definition = this.engine.getRepositoryService().getProcessDefinition(this.processDefinitionId);
        InputStream processDiagram = this.engine.getRepositoryService().getProcessDiagram(this.processDefinitionId);
        if (processDiagram == null) {
            return Response.noContent().build();
        }
        String fileName = definition.getDiagramResourceName();
        return Response.ok((Object)processDiagram).header("Content-Disposition", (Object)URLEncodingUtil.buildAttachmentValue(fileName)).type(ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix(fileName)).build();
    }

    public static String getMediaTypeForFileSuffix(String fileName) {
        String mediaType = "application/octet-stream";
        if (fileName != null) {
            if ((fileName = fileName.toLowerCase()).endsWith(".png")) {
                mediaType = "image/png";
            } else if (fileName.endsWith(".svg")) {
                mediaType = "image/svg+xml";
            } else if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
                mediaType = "image/jpeg";
            } else if (fileName.endsWith(".gif")) {
                mediaType = "image/gif";
            } else if (fileName.endsWith(".bmp")) {
                mediaType = "image/bmp";
            }
        }
        return mediaType;
    }

    @Override
    public FormDto getStartForm() {
        StartFormData formData;
        FormService formService = this.engine.getFormService();
        try {
            formData = formService.getStartFormData(this.processDefinitionId);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot get start form data for process definition " + this.processDefinitionId);
        }
        FormDto dto = FormDto.fromFormData((FormData)formData);
        if ((dto.getKey() == null || dto.getKey().isEmpty()) && dto.getOperatonFormRef() == null && formData != null && formData.getFormFields() != null && !formData.getFormFields().isEmpty()) {
            dto.setKey("embedded:engine://engine/:engine/process-definition/" + this.processDefinitionId + "/rendered-form");
        }
        dto.setContextPath(ApplicationContextPathUtil.getApplicationPathByProcessDefinitionId(this.engine, this.processDefinitionId));
        return dto;
    }

    @Override
    public Response getRenderedForm() {
        FormService formService = this.engine.getFormService();
        Object startForm = formService.getRenderedStartForm(this.processDefinitionId);
        if (startForm != null) {
            String content = startForm.toString();
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(EncodingUtil.DEFAULT_ENCODING));
            return Response.ok((Object)stream).type("application/xhtml+xml").build();
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching rendered start form for process definition with the id " + this.processDefinitionId + " found.");
    }

    @Override
    public void updateSuspensionState(ProcessDefinitionSuspensionStateDto dto) {
        try {
            dto.setProcessDefinitionId(this.processDefinitionId);
            dto.updateSuspensionState(this.engine);
        }
        catch (IllegalArgumentException e) {
            String message = "The suspension state of Process Definition with id %s could not be updated due to: %s".formatted(this.processDefinitionId, e.getMessage());
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, message);
        }
    }

    @Override
    public void updateHistoryTimeToLive(HistoryTimeToLiveDto historyTimeToLiveDto) {
        this.engine.getRepositoryService().updateProcessDefinitionHistoryTimeToLive(this.processDefinitionId, historyTimeToLiveDto.getHistoryTimeToLive());
    }

    @Override
    public Map<String, VariableValueDto> getFormVariables(String variableNames, boolean deserializeValues) {
        FormService formService = this.engine.getFormService();
        Object formVariables = null;
        if (variableNames != null) {
            StringListConverter stringListConverter = new StringListConverter();
            formVariables = stringListConverter.convertQueryParameterToType(variableNames);
        }
        VariableMap startFormVariables = formService.getStartFormVariables(this.processDefinitionId, formVariables, deserializeValues);
        return VariableValueDto.fromMap(startFormVariables);
    }

    @Override
    public List<CalledProcessDefinitionDto> getStaticCalledProcessDefinitions() {
        try {
            return this.engine.getRepositoryService().getStaticCalledProcessDefinitions(this.processDefinitionId).stream().map(CalledProcessDefinitionDto::from).toList();
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }

    @Override
    public void restartProcessInstance(RestartProcessInstanceDto restartProcessInstanceDto) {
        try {
            this.createRestartProcessInstanceBuilder(restartProcessInstanceDto).execute();
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public BatchDto restartProcessInstanceAsync(RestartProcessInstanceDto restartProcessInstanceDto) {
        try {
            Batch batch = this.createRestartProcessInstanceBuilder(restartProcessInstanceDto).executeAsync();
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    private RestartProcessInstanceBuilder createRestartProcessInstanceBuilder(RestartProcessInstanceDto restartProcessInstanceDto) {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        RestartProcessInstanceBuilder builder = runtimeService.restartProcessInstances(this.processDefinitionId);
        if (restartProcessInstanceDto.getProcessInstanceIds() != null) {
            builder.processInstanceIds(restartProcessInstanceDto.getProcessInstanceIds());
        }
        if (restartProcessInstanceDto.getHistoricProcessInstanceQuery() != null) {
            builder.historicProcessInstanceQuery((HistoricProcessInstanceQuery)restartProcessInstanceDto.getHistoricProcessInstanceQuery().toQuery(this.engine));
        }
        if (restartProcessInstanceDto.isInitialVariables()) {
            builder.initialSetOfVariables();
        }
        if (restartProcessInstanceDto.isWithoutBusinessKey()) {
            builder.withoutBusinessKey();
        }
        if (restartProcessInstanceDto.isSkipCustomListeners()) {
            builder.skipCustomListeners();
        }
        if (restartProcessInstanceDto.isSkipIoMappings()) {
            builder.skipIoMappings();
        }
        restartProcessInstanceDto.applyTo(builder, this.engine, this.objectMapper);
        return builder;
    }

    @Override
    public Response getDeployedStartForm() {
        try {
            InputStream deployedStartForm = this.engine.getFormService().getDeployedStartForm(this.processDefinitionId);
            return Response.ok((Object)deployedStartForm, (String)this.getStartFormMediaType(this.processDefinitionId)).build();
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (BadUserRequestException | NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        catch (AuthorizationException e) {
            throw new InvalidRequestException(Response.Status.FORBIDDEN, e.getMessage());
        }
    }

    protected String getStartFormMediaType(String processDefinitionId) {
        String formKey = this.engine.getFormService().getStartFormKey(processDefinitionId);
        OperatonFormRef operatonFormRef = this.engine.getFormService().getStartFormData(processDefinitionId).getOperatonFormRef();
        if (formKey != null) {
            return ContentTypeUtil.getFormContentType(formKey);
        }
        if (operatonFormRef != null) {
            return ContentTypeUtil.getFormContentType(operatonFormRef);
        }
        return "application/xhtml+xml";
    }
}

