/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.runtime.impl;

import io.openbpm.bpm.engine.IdentityService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.TaskService;
import io.openbpm.bpm.engine.exception.NullValueException;
import io.openbpm.bpm.engine.history.HistoricProcessInstance;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.identity.Authentication;
import io.openbpm.bpm.engine.rest.dto.task.CommentDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.sub.runtime.ProcessInstanceCommentResource;
import io.openbpm.bpm.engine.task.Comment;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProcessInstanceCommentResourceImpl
implements ProcessInstanceCommentResource {
    private final ProcessEngine engine;
    private final String processInstanceId;

    public ProcessInstanceCommentResourceImpl(ProcessEngine engine, String processInstanceId) {
        this.engine = engine;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public List<CommentDto> getComments() {
        if (!this.isHistoryEnabled()) {
            return Collections.emptyList();
        }
        this.ensureProcessInstanceExists(Response.Status.NOT_FOUND);
        List processInstanceComments = this.engine.getTaskService().getProcessInstanceComments(this.processInstanceId);
        ArrayList<CommentDto> comments = new ArrayList<CommentDto>();
        for (Comment comment : processInstanceComments) {
            comments.add(CommentDto.fromComment(comment));
        }
        return comments;
    }

    @Override
    public void deleteComment(String commentId) {
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        this.ensureProcessInstanceExists(Response.Status.NOT_FOUND);
        TaskService taskService = this.engine.getTaskService();
        try {
            taskService.deleteProcessInstanceComment(this.processInstanceId, commentId);
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public void updateComment(CommentDto comment) {
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        this.ensureProcessInstanceExists(Response.Status.NOT_FOUND);
        TaskService taskService = this.engine.getTaskService();
        try {
            taskService.updateProcessInstanceComment(this.processInstanceId, comment.getId(), comment.getMessage());
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    @Override
    public void deleteComments() {
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        this.ensureProcessInstanceExists(Response.Status.NOT_FOUND);
        TaskService taskService = this.engine.getTaskService();
        try {
            taskService.deleteProcessInstanceComments(this.processInstanceId);
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }

    private void ensureHistoryEnabled(Response.Status status) {
        if (!this.isHistoryEnabled()) {
            throw new InvalidRequestException(status, "History is not enabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHistoryEnabled() {
        IdentityService identityService = this.engine.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        try {
            identityService.clearAuthentication();
            int historyLevel = this.engine.getManagementService().getHistoryLevel();
            boolean bl = historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE;
            return bl;
        }
        finally {
            identityService.setAuthentication(currentAuthentication);
        }
    }

    private void ensureProcessInstanceExists(Response.Status status) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.engine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
        if (historicProcessInstance == null) {
            throw new InvalidRequestException(status, "No process instance found for id " + this.processInstanceId);
        }
    }
}

