/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.bpmn.builder;

import io.openbpm.bpm.model.bpmn.BpmnModelException;
import io.openbpm.bpm.model.bpmn.BpmnModelInstance;
import io.openbpm.bpm.model.bpmn.builder.AbstractThrowEventBuilder;
import io.openbpm.bpm.model.bpmn.builder.EndEventBuilder;
import io.openbpm.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import io.openbpm.bpm.model.bpmn.builder.SubProcessBuilder;
import io.openbpm.bpm.model.bpmn.builder.TransactionBuilder;
import io.openbpm.bpm.model.bpmn.instance.BpmnModelElementInstance;
import io.openbpm.bpm.model.bpmn.instance.EndEvent;
import io.openbpm.bpm.model.bpmn.instance.IntermediateThrowEvent;
import io.openbpm.bpm.model.bpmn.instance.SubProcess;
import io.openbpm.bpm.model.bpmn.instance.Transaction;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;

public abstract class AbstractBpmnModelElementBuilder<B extends AbstractBpmnModelElementBuilder<B, E>, E extends BpmnModelElementInstance> {
    protected final BpmnModelInstance modelInstance;
    protected final E element;
    protected final B myself;

    protected AbstractBpmnModelElementBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        this.modelInstance = modelInstance;
        this.myself = (AbstractBpmnModelElementBuilder)selfType.cast(this);
        this.element = element;
    }

    public BpmnModelInstance done() {
        return this.modelInstance;
    }

    public SubProcessBuilder subProcessDone() {
        BpmnModelElementInstance lastSubProcess = this.element.getScope();
        if (lastSubProcess instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)lastSubProcess;
            return subProcess.builder();
        }
        throw new BpmnModelException("Unable to find a parent subProcess.");
    }

    public TransactionBuilder transactionDone() {
        BpmnModelElementInstance lastTransaction = this.element.getScope();
        if (lastTransaction instanceof Transaction) {
            Transaction transaction = (Transaction)lastTransaction;
            return new TransactionBuilder(this.modelInstance, transaction);
        }
        throw new BpmnModelException("Unable to find a parent transaction.");
    }

    public AbstractThrowEventBuilder throwEventDefinitionDone() {
        ModelElementInstance lastEvent = this.element.getDomElement().getParentElement().getModelElementInstance();
        if (lastEvent instanceof IntermediateThrowEvent) {
            IntermediateThrowEvent intermediateThrowEvent = (IntermediateThrowEvent)lastEvent;
            return new IntermediateThrowEventBuilder(this.modelInstance, intermediateThrowEvent);
        }
        if (lastEvent instanceof EndEvent) {
            EndEvent endEvent = (EndEvent)lastEvent;
            return new EndEventBuilder(this.modelInstance, endEvent);
        }
        throw new BpmnModelException("Unable to find a parent event.");
    }

    public E getElement() {
        return this.element;
    }
}

