/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.bpmn.builder;

import io.openbpm.bpm.model.bpmn.AssociationDirection;
import io.openbpm.bpm.model.bpmn.BpmnModelException;
import io.openbpm.bpm.model.bpmn.BpmnModelInstance;
import io.openbpm.bpm.model.bpmn.builder.AbstractActivityBuilder;
import io.openbpm.bpm.model.bpmn.builder.AbstractFlowElementBuilder;
import io.openbpm.bpm.model.bpmn.builder.AbstractGatewayBuilder;
import io.openbpm.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.openbpm.bpm.model.bpmn.builder.CallActivityBuilder;
import io.openbpm.bpm.model.bpmn.builder.EndEventBuilder;
import io.openbpm.bpm.model.bpmn.builder.EventBasedGatewayBuilder;
import io.openbpm.bpm.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.openbpm.bpm.model.bpmn.builder.InclusiveGatewayBuilder;
import io.openbpm.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.openbpm.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import io.openbpm.bpm.model.bpmn.builder.ManualTaskBuilder;
import io.openbpm.bpm.model.bpmn.builder.ParallelGatewayBuilder;
import io.openbpm.bpm.model.bpmn.builder.ReceiveTaskBuilder;
import io.openbpm.bpm.model.bpmn.builder.ScriptTaskBuilder;
import io.openbpm.bpm.model.bpmn.builder.SendTaskBuilder;
import io.openbpm.bpm.model.bpmn.builder.SequenceFlowBuilder;
import io.openbpm.bpm.model.bpmn.builder.ServiceTaskBuilder;
import io.openbpm.bpm.model.bpmn.builder.SubProcessBuilder;
import io.openbpm.bpm.model.bpmn.builder.TransactionBuilder;
import io.openbpm.bpm.model.bpmn.builder.UserTaskBuilder;
import io.openbpm.bpm.model.bpmn.instance.Activity;
import io.openbpm.bpm.model.bpmn.instance.Association;
import io.openbpm.bpm.model.bpmn.instance.BaseElement;
import io.openbpm.bpm.model.bpmn.instance.BoundaryEvent;
import io.openbpm.bpm.model.bpmn.instance.BpmnModelElementInstance;
import io.openbpm.bpm.model.bpmn.instance.BusinessRuleTask;
import io.openbpm.bpm.model.bpmn.instance.CallActivity;
import io.openbpm.bpm.model.bpmn.instance.CompensateEventDefinition;
import io.openbpm.bpm.model.bpmn.instance.ConditionExpression;
import io.openbpm.bpm.model.bpmn.instance.EndEvent;
import io.openbpm.bpm.model.bpmn.instance.EventBasedGateway;
import io.openbpm.bpm.model.bpmn.instance.EventDefinition;
import io.openbpm.bpm.model.bpmn.instance.ExclusiveGateway;
import io.openbpm.bpm.model.bpmn.instance.FlowNode;
import io.openbpm.bpm.model.bpmn.instance.Gateway;
import io.openbpm.bpm.model.bpmn.instance.InclusiveGateway;
import io.openbpm.bpm.model.bpmn.instance.IntermediateCatchEvent;
import io.openbpm.bpm.model.bpmn.instance.IntermediateThrowEvent;
import io.openbpm.bpm.model.bpmn.instance.ManualTask;
import io.openbpm.bpm.model.bpmn.instance.ParallelGateway;
import io.openbpm.bpm.model.bpmn.instance.ReceiveTask;
import io.openbpm.bpm.model.bpmn.instance.ScriptTask;
import io.openbpm.bpm.model.bpmn.instance.SendTask;
import io.openbpm.bpm.model.bpmn.instance.SequenceFlow;
import io.openbpm.bpm.model.bpmn.instance.ServiceTask;
import io.openbpm.bpm.model.bpmn.instance.SubProcess;
import io.openbpm.bpm.model.bpmn.instance.Transaction;
import io.openbpm.bpm.model.bpmn.instance.UserTask;
import io.openbpm.bpm.model.bpmn.instance.bpmndi.BpmnShape;
import io.openbpm.bpm.model.bpmn.instance.operaton.OperatonExecutionListener;
import io.openbpm.bpm.model.bpmn.instance.operaton.OperatonFailedJobRetryTimeCycle;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;

public abstract class AbstractFlowNodeBuilder<B extends AbstractFlowNodeBuilder<B, E>, E extends FlowNode>
extends AbstractFlowElementBuilder<B, E> {
    private SequenceFlowBuilder currentSequenceFlowBuilder;
    protected boolean compensationStarted;
    protected BoundaryEvent compensateBoundaryEvent;

    protected AbstractFlowNodeBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    private SequenceFlowBuilder getCurrentSequenceFlowBuilder() {
        if (this.currentSequenceFlowBuilder == null) {
            SequenceFlow sequenceFlow = this.createSibling(SequenceFlow.class);
            this.currentSequenceFlowBuilder = sequenceFlow.builder();
        }
        return this.currentSequenceFlowBuilder;
    }

    public B condition(String name, String condition) {
        if (name != null) {
            this.getCurrentSequenceFlowBuilder().name(name);
        }
        ConditionExpression conditionExpression = this.createInstance(ConditionExpression.class);
        conditionExpression.setTextContent(condition);
        this.getCurrentSequenceFlowBuilder().condition(conditionExpression);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    protected void connectTarget(FlowNode target) {
        if (this.isBoundaryEventWithStartedCompensation()) {
            if (target instanceof Activity) {
                Activity activity = (Activity)target;
                activity.setForCompensation(true);
            }
            this.connectTargetWithAssociation(target);
        } else {
            if (this.isCompensationHandler()) {
                throw new BpmnModelException("Only single compensation handler allowed. Call compensationDone() to continue main flow.");
            }
            this.connectTargetWithSequenceFlow(target);
        }
    }

    protected void connectTargetWithSequenceFlow(FlowNode target) {
        ((SequenceFlowBuilder)this.getCurrentSequenceFlowBuilder().from((FlowNode)this.element)).to(target);
        SequenceFlow sequenceFlow = (SequenceFlow)this.getCurrentSequenceFlowBuilder().getElement();
        this.createEdge(sequenceFlow);
        this.currentSequenceFlowBuilder = null;
    }

    protected void connectTargetWithAssociation(FlowNode target) {
        Association association = (Association)this.modelInstance.newInstance(Association.class);
        association.setTarget(target);
        association.setSource((BaseElement)this.element);
        association.setAssociationDirection(AssociationDirection.One);
        ((FlowNode)this.element).getParentElement().addChildElement((ModelElementInstance)association);
        this.createEdge(association);
    }

    public AbstractFlowNodeBuilder compensationDone() {
        if (this.compensateBoundaryEvent != null) {
            return this.compensateBoundaryEvent.getAttachedTo().builder();
        }
        throw new BpmnModelException("No compensation in progress. Call compensationStart() first.");
    }

    public B sequenceFlowId(String sequenceFlowId) {
        this.getCurrentSequenceFlowBuilder().id(sequenceFlowId);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    private <T extends FlowNode> T createTarget(Class<T> typeClass) {
        return this.createTarget(typeClass, null);
    }

    protected <T extends FlowNode> T createTarget(Class<T> typeClass, String identifier) {
        FlowNode target = (FlowNode)this.createSibling(typeClass, identifier);
        BpmnShape targetBpmnShape = this.createBpmnShape(target);
        this.setCoordinates(targetBpmnShape);
        this.connectTarget(target);
        this.resizeSubProcess(targetBpmnShape);
        return (T)target;
    }

    protected <T extends AbstractFlowNodeBuilder, F extends FlowNode> T createTargetBuilder(Class<F> typeClass) {
        return this.createTargetBuilder(typeClass, null);
    }

    protected <T extends AbstractFlowNodeBuilder, F extends FlowNode> T createTargetBuilder(Class<F> typeClass, String id) {
        AbstractFlowNodeBuilder builder = this.createTarget(typeClass, id).builder();
        if (this.compensationStarted) {
            builder.compensateBoundaryEvent = this.compensateBoundaryEvent;
        }
        return (T)builder;
    }

    public ServiceTaskBuilder serviceTask() {
        return (ServiceTaskBuilder)this.createTargetBuilder(ServiceTask.class);
    }

    public ServiceTaskBuilder serviceTask(String id) {
        return (ServiceTaskBuilder)this.createTargetBuilder(ServiceTask.class, id);
    }

    public SendTaskBuilder sendTask() {
        return (SendTaskBuilder)this.createTargetBuilder(SendTask.class);
    }

    public SendTaskBuilder sendTask(String id) {
        return (SendTaskBuilder)this.createTargetBuilder(SendTask.class, id);
    }

    public UserTaskBuilder userTask() {
        return (UserTaskBuilder)this.createTargetBuilder(UserTask.class);
    }

    public UserTaskBuilder userTask(String id) {
        return (UserTaskBuilder)this.createTargetBuilder(UserTask.class, id);
    }

    public BusinessRuleTaskBuilder businessRuleTask() {
        return (BusinessRuleTaskBuilder)this.createTargetBuilder(BusinessRuleTask.class);
    }

    public BusinessRuleTaskBuilder businessRuleTask(String id) {
        return (BusinessRuleTaskBuilder)this.createTargetBuilder(BusinessRuleTask.class, id);
    }

    public ScriptTaskBuilder scriptTask() {
        return (ScriptTaskBuilder)this.createTargetBuilder(ScriptTask.class);
    }

    public ScriptTaskBuilder scriptTask(String id) {
        return (ScriptTaskBuilder)this.createTargetBuilder(ScriptTask.class, id);
    }

    public ReceiveTaskBuilder receiveTask() {
        return (ReceiveTaskBuilder)this.createTargetBuilder(ReceiveTask.class);
    }

    public ReceiveTaskBuilder receiveTask(String id) {
        return (ReceiveTaskBuilder)this.createTargetBuilder(ReceiveTask.class, id);
    }

    public ManualTaskBuilder manualTask() {
        return (ManualTaskBuilder)this.createTargetBuilder(ManualTask.class);
    }

    public ManualTaskBuilder manualTask(String id) {
        return (ManualTaskBuilder)this.createTargetBuilder(ManualTask.class, id);
    }

    public EndEventBuilder endEvent() {
        return this.createTarget(EndEvent.class).builder();
    }

    public EndEventBuilder endEvent(String id) {
        return this.createTarget(EndEvent.class, id).builder();
    }

    public ParallelGatewayBuilder parallelGateway() {
        return this.createTarget(ParallelGateway.class).builder();
    }

    public ParallelGatewayBuilder parallelGateway(String id) {
        return this.createTarget(ParallelGateway.class, id).builder();
    }

    public ExclusiveGatewayBuilder exclusiveGateway() {
        return this.createTarget(ExclusiveGateway.class).builder();
    }

    public InclusiveGatewayBuilder inclusiveGateway() {
        return this.createTarget(InclusiveGateway.class).builder();
    }

    public EventBasedGatewayBuilder eventBasedGateway() {
        return this.createTarget(EventBasedGateway.class).builder();
    }

    public ExclusiveGatewayBuilder exclusiveGateway(String id) {
        return this.createTarget(ExclusiveGateway.class, id).builder();
    }

    public InclusiveGatewayBuilder inclusiveGateway(String id) {
        return this.createTarget(InclusiveGateway.class, id).builder();
    }

    public IntermediateCatchEventBuilder intermediateCatchEvent() {
        return this.createTarget(IntermediateCatchEvent.class).builder();
    }

    public IntermediateCatchEventBuilder intermediateCatchEvent(String id) {
        return this.createTarget(IntermediateCatchEvent.class, id).builder();
    }

    public IntermediateThrowEventBuilder intermediateThrowEvent() {
        return this.createTarget(IntermediateThrowEvent.class).builder();
    }

    public IntermediateThrowEventBuilder intermediateThrowEvent(String id) {
        return this.createTarget(IntermediateThrowEvent.class, id).builder();
    }

    public CallActivityBuilder callActivity() {
        return this.createTarget(CallActivity.class).builder();
    }

    public CallActivityBuilder callActivity(String id) {
        return this.createTarget(CallActivity.class, id).builder();
    }

    public SubProcessBuilder subProcess() {
        return this.createTarget(SubProcess.class).builder();
    }

    public SubProcessBuilder subProcess(String id) {
        return this.createTarget(SubProcess.class, id).builder();
    }

    public TransactionBuilder transaction() {
        Transaction transaction = this.createTarget(Transaction.class);
        return new TransactionBuilder(this.modelInstance, transaction);
    }

    public TransactionBuilder transaction(String id) {
        Transaction transaction = this.createTarget(Transaction.class, id);
        return new TransactionBuilder(this.modelInstance, transaction);
    }

    public Gateway findLastGateway() {
        FlowNode lastGateway = (FlowNode)this.element;
        try {
            while (!((lastGateway = lastGateway.getPreviousNodes().singleResult()) instanceof Gateway)) {
            }
            Gateway gateway = (Gateway)lastGateway;
            return gateway;
        }
        catch (BpmnModelException e) {
            throw new BpmnModelException("Unable to determine an unique previous gateway of " + lastGateway.getId(), (Throwable)((Object)e));
        }
    }

    public AbstractGatewayBuilder moveToLastGateway() {
        return this.findLastGateway().builder();
    }

    public AbstractFlowNodeBuilder moveToNode(String identifier) {
        ModelElementInstance instance = this.modelInstance.getModelElementById(identifier);
        if (instance instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)instance;
            return flowNode.builder();
        }
        throw new BpmnModelException("Flow node not found for id " + identifier);
    }

    public <T extends AbstractActivityBuilder> T moveToActivity(String identifier) {
        ModelElementInstance instance = this.modelInstance.getModelElementById(identifier);
        if (instance instanceof Activity) {
            Activity activity = (Activity)instance;
            return (T)((AbstractActivityBuilder)activity.builder());
        }
        throw new BpmnModelException("Activity not found for id " + identifier);
    }

    public AbstractFlowNodeBuilder connectTo(String identifier) {
        ModelElementInstance target = this.modelInstance.getModelElementById(identifier);
        if (target == null) {
            throw new BpmnModelException("Unable to connect " + ((FlowNode)this.element).getId() + " to element " + identifier + " cause it not exists.");
        }
        if (!(target instanceof FlowNode)) {
            throw new BpmnModelException("Unable to connect " + ((FlowNode)this.element).getId() + " to element " + identifier + " cause its not a flow node.");
        }
        FlowNode targetNode = (FlowNode)target;
        this.connectTarget(targetNode);
        return targetNode.builder();
    }

    public B operatonAsyncBefore(boolean asyncBefore) {
        ((FlowNode)this.element).setOperatonAsyncBefore(asyncBefore);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B operatonAsyncBefore() {
        ((FlowNode)this.element).setOperatonAsyncBefore(true);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B operatonAsyncAfter(boolean asyncAfter) {
        ((FlowNode)this.element).setOperatonAsyncAfter(asyncAfter);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B operatonAsyncAfter() {
        ((FlowNode)this.element).setOperatonAsyncAfter(true);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B notOperatonExclusive() {
        ((FlowNode)this.element).setOperatonExclusive(false);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B operatonExclusive(boolean exclusive) {
        ((FlowNode)this.element).setOperatonExclusive(exclusive);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B operatonJobPriority(String jobPriority) {
        ((FlowNode)this.element).setOperatonJobPriority(jobPriority);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B operatonFailedJobRetryTimeCycle(String retryTimeCycle) {
        OperatonFailedJobRetryTimeCycle failedJobRetryTimeCycle = this.createInstance(OperatonFailedJobRetryTimeCycle.class);
        failedJobRetryTimeCycle.setTextContent(retryTimeCycle);
        this.addExtensionElement(failedJobRetryTimeCycle);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B operatonExecutionListenerClass(String eventName, Class listenerClass) {
        return this.operatonExecutionListenerClass(eventName, listenerClass.getName());
    }

    public B operatonExecutionListenerClass(String eventName, String fullQualifiedClassName) {
        OperatonExecutionListener executionListener = this.createInstance(OperatonExecutionListener.class);
        executionListener.setOperatonEvent(eventName);
        executionListener.setOperatonClass(fullQualifiedClassName);
        this.addExtensionElement(executionListener);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B operatonExecutionListenerExpression(String eventName, String expression) {
        OperatonExecutionListener executionListener = this.createInstance(OperatonExecutionListener.class);
        executionListener.setOperatonEvent(eventName);
        executionListener.setOperatonExpression(expression);
        this.addExtensionElement(executionListener);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B operatonExecutionListenerDelegateExpression(String eventName, String delegateExpression) {
        OperatonExecutionListener executionListener = this.createInstance(OperatonExecutionListener.class);
        executionListener.setOperatonEvent(eventName);
        executionListener.setOperatonDelegateExpression(delegateExpression);
        this.addExtensionElement(executionListener);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B compensationStart() {
        BpmnModelElementInstance bpmnModelElementInstance = this.element;
        if (bpmnModelElementInstance instanceof BoundaryEvent) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)bpmnModelElementInstance;
            for (EventDefinition eventDefinition : boundaryEvent.getEventDefinitions()) {
                if (!(eventDefinition instanceof CompensateEventDefinition)) continue;
                this.compensateBoundaryEvent = boundaryEvent;
                this.compensationStarted = true;
                return (B)((AbstractFlowNodeBuilder)this.myself);
            }
        }
        throw new BpmnModelException("Compensation can only be started on a boundary event with a compensation event definition");
    }

    protected boolean isBoundaryEventWithStartedCompensation() {
        return this.compensationStarted && this.compensateBoundaryEvent != null;
    }

    protected boolean isCompensationHandler() {
        return !this.compensationStarted && this.compensateBoundaryEvent != null;
    }
}

