/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.application;

import io.openbpm.bpm.application.InvocationContext;
import io.openbpm.bpm.application.ProcessApplication;
import io.openbpm.bpm.application.ProcessApplicationExecutionException;
import io.openbpm.bpm.application.ProcessApplicationInterface;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.impl.DefaultElResolverLookup;
import io.openbpm.bpm.application.impl.ProcessApplicationLogger;
import io.openbpm.bpm.application.impl.ProcessApplicationScriptEnvironment;
import io.openbpm.bpm.container.RuntimeContainerDelegate;
import io.openbpm.bpm.engine.delegate.ExecutionListener;
import io.openbpm.bpm.engine.delegate.TaskListener;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.scripting.ExecutableScript;
import io.openbpm.bpm.engine.impl.util.ClassLoaderUtil;
import io.openbpm.bpm.engine.impl.variable.serializer.VariableSerializers;
import io.openbpm.bpm.engine.repository.DeploymentBuilder;
import jakarta.el.BeanELResolver;
import jakarta.el.ELResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.script.ScriptEngine;

public abstract class AbstractProcessApplication
implements ProcessApplicationInterface {
    private static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;
    protected ELResolver processApplicationElResolver;
    protected BeanELResolver processApplicationBeanElResolver;
    protected ProcessApplicationScriptEnvironment processApplicationScriptEnvironment;
    protected VariableSerializers variableSerializers;
    protected boolean isDeployed;
    protected String defaultDeployToEngineName = "default";

    @Override
    public void deploy() {
        if (this.isDeployed) {
            LOG.alreadyDeployed();
        } else {
            try {
                ProcessApplicationReference reference = this.getReference();
                Context.setCurrentProcessApplication(reference);
                RuntimeContainerDelegate.INSTANCE.get().deployProcessApplication(this);
                this.isDeployed = true;
            }
            finally {
                Context.removeCurrentProcessApplication();
            }
        }
    }

    @Override
    public void undeploy() {
        if (!this.isDeployed) {
            LOG.notDeployed();
        } else {
            RuntimeContainerDelegate.INSTANCE.get().undeployProcessApplication(this);
            this.isDeployed = false;
        }
    }

    @Override
    public void createDeployment(String processArchiveName, DeploymentBuilder deploymentBuilder) {
    }

    @Override
    public String getName() {
        Class<?> processApplicationClass = this.getClass();
        String name = null;
        ProcessApplication annotation = processApplicationClass.getAnnotation(ProcessApplication.class);
        if (annotation != null && ((name = annotation.value()) == null || name.isEmpty())) {
            name = annotation.name();
        }
        if (name == null || name.isEmpty()) {
            name = this.autodetectProcessApplicationName();
        }
        return name;
    }

    protected abstract String autodetectProcessApplicationName();

    @Override
    public <T> T execute(Callable<T> callable) throws ProcessApplicationExecutionException {
        ClassLoader originalClassloader = ClassLoaderUtil.getContextClassloader();
        ClassLoader processApplicationClassloader = this.getProcessApplicationClassloader();
        try {
            ClassLoaderUtil.setContextClassloader(processApplicationClassloader);
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw LOG.processApplicationExecutionException(e);
        }
        finally {
            ClassLoaderUtil.setContextClassloader(originalClassloader);
        }
    }

    @Override
    public <T> T execute(Callable<T> callable, InvocationContext invocationContext) throws ProcessApplicationExecutionException {
        return this.execute(callable);
    }

    @Override
    public ClassLoader getProcessApplicationClassloader() {
        return ClassLoaderUtil.getClassloader(this.getClass());
    }

    @Override
    public ProcessApplicationInterface getRawObject() {
        return this;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ELResolver getElResolver() {
        if (this.processApplicationElResolver == null) {
            AbstractProcessApplication abstractProcessApplication = this;
            synchronized (abstractProcessApplication) {
                if (this.processApplicationElResolver == null) {
                    this.processApplicationElResolver = this.initProcessApplicationElResolver();
                }
            }
        }
        return this.processApplicationElResolver;
    }

    @Override
    public synchronized BeanELResolver getBeanElResolver() {
        if (this.processApplicationBeanElResolver == null) {
            this.processApplicationBeanElResolver = new BeanELResolver();
        }
        return this.processApplicationBeanElResolver;
    }

    protected ELResolver initProcessApplicationElResolver() {
        return DefaultElResolverLookup.lookupResolver(this);
    }

    @Override
    public ExecutionListener getExecutionListener() {
        return null;
    }

    @Override
    public TaskListener getTaskListener() {
        return null;
    }

    public ScriptEngine getScriptEngineForName(String name, boolean cache) {
        return this.getProcessApplicationScriptEnvironment().getScriptEngineForName(name, cache);
    }

    public Map<String, List<ExecutableScript>> getEnvironmentScripts() {
        return this.getProcessApplicationScriptEnvironment().getEnvironmentScripts();
    }

    protected synchronized ProcessApplicationScriptEnvironment getProcessApplicationScriptEnvironment() {
        if (this.processApplicationScriptEnvironment == null) {
            this.processApplicationScriptEnvironment = new ProcessApplicationScriptEnvironment(this);
        }
        return this.processApplicationScriptEnvironment;
    }

    public VariableSerializers getVariableSerializers() {
        return this.variableSerializers;
    }

    public void setVariableSerializers(VariableSerializers variableSerializers) {
        this.variableSerializers = variableSerializers;
    }

    public String getDefaultDeployToEngineName() {
        return this.defaultDeployToEngineName;
    }

    protected void setDefaultDeployToEngineName(String defaultDeployToEngineName) {
        this.defaultDeployToEngineName = defaultDeployToEngineName;
    }
}

