/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.application;

import io.openbpm.bpm.application.ProcessApplicationInterface;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.application.impl.ProcessApplicationContextImpl;
import io.openbpm.bpm.application.impl.ProcessApplicationIdentifier;
import java.util.concurrent.Callable;

public final class ProcessApplicationContext {
    public static void setCurrentProcessApplication(String processApplicationName) {
        ProcessApplicationContextImpl.set(new ProcessApplicationIdentifier(processApplicationName));
    }

    public static void setCurrentProcessApplication(ProcessApplicationReference reference) {
        ProcessApplicationContextImpl.set(new ProcessApplicationIdentifier(reference));
    }

    public static void setCurrentProcessApplication(ProcessApplicationInterface processApplication) {
        ProcessApplicationContextImpl.set(new ProcessApplicationIdentifier(processApplication));
    }

    public static void clear() {
        ProcessApplicationContextImpl.clear();
    }

    public static <T> T withProcessApplicationContext(Callable<T> callable, String processApplicationName) throws Exception {
        try {
            ProcessApplicationContext.setCurrentProcessApplication(processApplicationName);
            T t = callable.call();
            return t;
        }
        finally {
            ProcessApplicationContext.clear();
        }
    }

    public static <T> T withProcessApplicationContext(Callable<T> callable, ProcessApplicationReference reference) throws Exception {
        try {
            ProcessApplicationContext.setCurrentProcessApplication(reference);
            T t = callable.call();
            return t;
        }
        finally {
            ProcessApplicationContext.clear();
        }
    }

    public static <T> T withProcessApplicationContext(Callable<T> callable, ProcessApplicationInterface processApplication) throws Exception {
        try {
            ProcessApplicationContext.setCurrentProcessApplication(processApplication);
            T t = callable.call();
            return t;
        }
        finally {
            ProcessApplicationContext.clear();
        }
    }

    private ProcessApplicationContext() {
    }
}

