/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.deployment;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.container.impl.deployment.scanning.ProcessApplicationScanningUtil;
import io.openbpm.bpm.container.impl.deployment.util.DeployedProcessArchive;
import io.openbpm.bpm.container.impl.metadata.PropertyHelper;
import io.openbpm.bpm.container.impl.spi.DeploymentOperation;
import io.openbpm.bpm.container.impl.spi.DeploymentOperationStep;
import io.openbpm.bpm.container.impl.spi.PlatformServiceContainer;
import io.openbpm.bpm.container.impl.spi.ServiceTypes;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.RepositoryService;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.impl.util.IoUtil;
import io.openbpm.bpm.engine.impl.util.StringUtil;
import io.openbpm.bpm.engine.repository.ProcessApplicationDeployment;
import io.openbpm.bpm.engine.repository.ProcessApplicationDeploymentBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeployProcessArchiveStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected final ProcessArchiveXml processArchive;
    protected URL metaFileUrl;
    protected ProcessApplicationDeployment deployment;

    public DeployProcessArchiveStep(ProcessArchiveXml parsedProcessArchive, URL url) {
        this.processArchive = parsedProcessArchive;
        this.metaFileUrl = url;
    }

    @Override
    public String getName() {
        return "Deployment of process archive '" + this.processArchive.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        ClassLoader processApplicationClassloader = processApplication.getProcessApplicationClassloader();
        ProcessEngine processEngine = this.getProcessEngine(serviceContainer, processApplication.getDefaultDeployToEngineName());
        HashMap<String, byte[]> deploymentMap = new HashMap<String, byte[]>();
        List<String> listedProcessResources = this.processArchive.getProcessResourceNames();
        for (String processResource : listedProcessResources) {
            InputStream resourceAsStream = null;
            try {
                resourceAsStream = processApplicationClassloader.getResourceAsStream(processResource);
                byte[] bytes = IoUtil.readInputStream(resourceAsStream, processResource);
                deploymentMap.put(processResource, bytes);
            }
            finally {
                IoUtil.closeSilently(resourceAsStream);
            }
        }
        if (PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isScanForProcessDefinitions", true)) {
            String paResourceRoot = this.processArchive.getProperties().get("resourceRootPath");
            String[] additionalResourceSuffixes = StringUtil.split(this.processArchive.getProperties().get("additionalResourceSuffixes"), ",");
            deploymentMap.putAll(this.findResources(processApplicationClassloader, paResourceRoot, additionalResourceSuffixes));
        }
        RepositoryService repositoryService = processEngine.getRepositoryService();
        ProcessApplicationDeploymentBuilder deploymentBuilder = repositoryService.createDeployment(processApplication.getReference());
        String deploymentName = this.processArchive.getName();
        if (deploymentName == null || deploymentName.isEmpty()) {
            deploymentName = processApplication.getName();
        }
        deploymentBuilder.name(deploymentName);
        String tenantId = this.processArchive.getTenantId();
        if (tenantId != null && !tenantId.isEmpty()) {
            deploymentBuilder.tenantId(tenantId);
        }
        deploymentBuilder.enableDuplicateFiltering(PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isDeployChangedOnly", false));
        if (PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isResumePreviousVersions", true)) {
            this.enableResumingOfPreviousVersions(deploymentBuilder);
        }
        for (Map.Entry deploymentResource : deploymentMap.entrySet()) {
            deploymentBuilder.addInputStream((String)deploymentResource.getKey(), new ByteArrayInputStream((byte[])deploymentResource.getValue()));
        }
        processApplication.createDeployment(this.processArchive.getName(), deploymentBuilder);
        Collection<String> deploymentResourceNames = deploymentBuilder.getResourceNames();
        if (!deploymentResourceNames.isEmpty()) {
            LOG.deploymentSummary(deploymentResourceNames, deploymentName);
            this.deployment = deploymentBuilder.deploy();
            HashMap<String, DeployedProcessArchive> processArchiveDeploymentMap = (HashMap<String, DeployedProcessArchive>)operationContext.getAttachment("processArchiveDeploymentMap");
            if (processArchiveDeploymentMap == null) {
                processArchiveDeploymentMap = new HashMap<String, DeployedProcessArchive>();
                operationContext.addAttachment("processArchiveDeploymentMap", processArchiveDeploymentMap);
            }
            processArchiveDeploymentMap.put(this.processArchive.getName(), new DeployedProcessArchive(this.deployment));
        } else {
            LOG.notCreatingPaDeployment(processApplication.getName());
        }
    }

    protected void enableResumingOfPreviousVersions(ProcessApplicationDeploymentBuilder deploymentBuilder) throws IllegalArgumentException {
        deploymentBuilder.resumePreviousVersions();
        String resumePreviousBy = this.processArchive.getProperties().get("resumePreviousBy");
        if (resumePreviousBy == null) {
            deploymentBuilder.resumePreviousVersionsBy("process-definition-key");
        } else if (this.isValidValueForResumePreviousBy(resumePreviousBy)) {
            deploymentBuilder.resumePreviousVersionsBy(resumePreviousBy);
        } else {
            StringBuilder b = new StringBuilder();
            b.append("Illegal value passed for property ").append("resumePreviousBy");
            b.append(". Value was ").append(resumePreviousBy);
            b.append(" expected ").append("deployment-name");
            b.append(" or ").append("process-definition-key").append(".");
            throw LOG.illegalValueForResumePreviousByProperty(b.toString());
        }
    }

    protected boolean isValidValueForResumePreviousBy(String resumePreviousBy) {
        return "deployment-name".equals(resumePreviousBy) || "process-definition-key".equals(resumePreviousBy);
    }

    protected Map<String, byte[]> findResources(ClassLoader processApplicationClassloader, String paResourceRoot, String[] additionalResourceSuffixes) {
        return ProcessApplicationScanningUtil.findResources(processApplicationClassloader, paResourceRoot, this.metaFileUrl, additionalResourceSuffixes);
    }

    @Override
    public void cancelOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        ProcessEngine processEngine = this.getProcessEngine(serviceContainer, processApplication.getDefaultDeployToEngineName());
        if (this.deployment != null && this.deployment.getProcessApplicationRegistration() != null) {
            processEngine.getManagementService().unregisterProcessApplication(this.deployment.getProcessApplicationRegistration().getDeploymentIds(), true);
        }
        if (this.deployment != null && PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isDeleteUponUndeploy", false) && processEngine != null) {
            processEngine.getRepositoryService().deleteDeployment(this.deployment.getId(), true);
        }
    }

    protected ProcessEngine getProcessEngine(PlatformServiceContainer serviceContainer) {
        return this.getProcessEngine(serviceContainer, "default");
    }

    protected ProcessEngine getProcessEngine(PlatformServiceContainer serviceContainer, String defaultDeployToProcessEngineName) {
        String processEngineName = this.processArchive.getProcessEngineName();
        if (processEngineName != null) {
            ProcessEngine processEngine = (ProcessEngine)serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, processEngineName);
            EnsureUtil.ensureNotNull("Cannot deploy process archive '" + this.processArchive.getName() + "' to process engine '" + processEngineName + "' no such process engine exists", "processEngine", (Object)processEngine);
            return processEngine;
        }
        ProcessEngine processEngine = (ProcessEngine)serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, defaultDeployToProcessEngineName);
        EnsureUtil.ensureNotNull("Cannot deploy process archive '" + this.processArchive.getName() + "' to default process: no such process engine exists", "processEngine", (Object)processEngine);
        return processEngine;
    }
}

