/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.deployment;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.PostDeploy;
import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.container.impl.deployment.util.InjectionUtil;
import io.openbpm.bpm.container.impl.spi.DeploymentOperation;
import io.openbpm.bpm.container.impl.spi.DeploymentOperationStep;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PostDeployInvocationStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    private static final String CALLBACK_NAME = "@PostDeploy";

    @Override
    public String getName() {
        return "Invoking @PostDeploy";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        String paName = processApplication.getName();
        Class<?> paClass = processApplication.getClass();
        Method postDeployMethod = InjectionUtil.detectAnnotatedMethod(paClass, PostDeploy.class);
        if (postDeployMethod == null) {
            LOG.debugPaLifecycleMethodNotFound(CALLBACK_NAME, paName);
            return;
        }
        LOG.debugFoundPaLifecycleCallbackMethod(CALLBACK_NAME, paName);
        Object[] injections = InjectionUtil.resolveInjections(operationContext, postDeployMethod);
        try {
            postDeployMethod.invoke((Object)processApplication, injections);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw LOG.exceptionWhileInvokingPaLifecycleCallback(CALLBACK_NAME, paName, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)cause;
                throw runtimeException;
            }
            throw LOG.exceptionWhileInvokingPaLifecycleCallback(CALLBACK_NAME, paName, e);
        }
    }
}

