/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.deployment;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.impl.metadata.spi.ProcessesXml;
import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import io.openbpm.bpm.container.impl.metadata.spi.ProcessEngineXml;
import io.openbpm.bpm.container.impl.spi.DeploymentOperation;
import io.openbpm.bpm.container.impl.spi.DeploymentOperationStep;
import io.openbpm.bpm.container.impl.spi.PlatformServiceContainer;
import io.openbpm.bpm.container.impl.spi.ServiceTypes;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.List;

public class ProcessesXmlStopProcessEnginesStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        JmxManagedProcessApplication deployedProcessApplication = (JmxManagedProcessApplication)serviceContainer.getService(ServiceTypes.PROCESS_APPLICATION, processApplication.getName());
        EnsureUtil.ensureNotNull("Cannot find process application with name " + processApplication.getName(), "deployedProcessApplication", (Object)deployedProcessApplication);
        List<ProcessesXml> processesXmls = deployedProcessApplication.getProcessesXmls();
        for (ProcessesXml processesXml : processesXmls) {
            this.stopProcessEngines(processesXml.getProcessEngines(), operationContext);
        }
    }

    protected void stopProcessEngines(List<ProcessEngineXml> processEngine, DeploymentOperation operationContext) {
        for (ProcessEngineXml parsedProcessEngine : processEngine) {
            this.stopProcessEngine(parsedProcessEngine.getName(), operationContext);
        }
    }

    protected void stopProcessEngine(String processEngineName, DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        try {
            serviceContainer.stopService(ServiceTypes.PROCESS_ENGINE, processEngineName);
        }
        catch (Exception e) {
            LOG.exceptionWhileStopping("Process Engine", processEngineName, e);
        }
    }
}

