/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.deployment;

import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.container.impl.spi.DeploymentOperation;
import io.openbpm.bpm.container.impl.spi.DeploymentOperationStep;
import io.openbpm.bpm.container.impl.spi.PlatformServiceContainer;
import io.openbpm.bpm.container.impl.spi.ServiceTypes;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import java.util.Set;

public class StopProcessEnginesStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        Set<String> serviceNames = serviceContainer.getServiceNames(ServiceTypes.PROCESS_ENGINE);
        for (String serviceName : serviceNames) {
            this.stopProcessEngine(serviceName, serviceContainer);
        }
    }

    private void stopProcessEngine(String serviceName, PlatformServiceContainer serviceContainer) {
        try {
            serviceContainer.stopService(serviceName);
        }
        catch (Exception e) {
            LOG.exceptionWhileStopping("Process Engine", serviceName, e);
        }
    }
}

