/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.deployment;

import io.openbpm.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import io.openbpm.bpm.container.impl.deployment.util.DeployedProcessArchive;
import io.openbpm.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import io.openbpm.bpm.container.impl.metadata.PropertyHelper;
import io.openbpm.bpm.container.impl.spi.DeploymentOperation;
import io.openbpm.bpm.container.impl.spi.DeploymentOperationStep;
import io.openbpm.bpm.container.impl.spi.PlatformServiceContainer;
import io.openbpm.bpm.container.impl.spi.ServiceTypes;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.RepositoryService;
import java.util.Map;

public class UndeployProcessArchiveStep
extends DeploymentOperationStep {
    protected String processArchvieName;
    protected JmxManagedProcessApplication deployedProcessApplication;
    protected ProcessArchiveXml processArchive;
    protected String processEngineName;

    public UndeployProcessArchiveStep(JmxManagedProcessApplication deployedProcessApplication, ProcessArchiveXml processArchive, String processEngineName) {
        this.deployedProcessApplication = deployedProcessApplication;
        this.processArchive = processArchive;
        this.processEngineName = processEngineName;
    }

    @Override
    public String getName() {
        return "Undeploying process archive " + this.processArchvieName;
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        Map<String, DeployedProcessArchive> processArchiveDeploymentMap = this.deployedProcessApplication.getProcessArchiveDeploymentMap();
        DeployedProcessArchive deployedProcessArchive = processArchiveDeploymentMap.get(this.processArchive.getName());
        ProcessEngine processEngine = (ProcessEngine)serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, this.processEngineName);
        processEngine.getManagementService().unregisterProcessApplication(deployedProcessArchive.getAllDeploymentIds(), true);
        if (PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isDeleteUponUndeploy", false)) {
            this.deleteDeployment(deployedProcessArchive.getPrimaryDeploymentId(), processEngine.getRepositoryService());
        }
    }

    protected void deleteDeployment(String deploymentId, RepositoryService repositoryService) {
        repositoryService.deleteDeployment(deploymentId, true, true);
    }
}

