/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.deployment;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import io.openbpm.bpm.application.impl.metadata.spi.ProcessesXml;
import io.openbpm.bpm.container.impl.deployment.UndeployProcessArchiveStep;
import io.openbpm.bpm.container.impl.deployment.util.DeployedProcessArchive;
import io.openbpm.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import io.openbpm.bpm.container.impl.spi.DeploymentOperation;
import io.openbpm.bpm.container.impl.spi.DeploymentOperationStep;
import io.openbpm.bpm.container.impl.spi.PlatformServiceContainer;
import io.openbpm.bpm.container.impl.spi.ServiceTypes;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.List;
import java.util.Map;

public class UndeployProcessArchivesStep
extends DeploymentOperationStep {
    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        JmxManagedProcessApplication deployedProcessApplication = (JmxManagedProcessApplication)serviceContainer.getService(ServiceTypes.PROCESS_APPLICATION, processApplication.getName());
        EnsureUtil.ensureNotNull("Cannot find process application with name " + processApplication.getName(), "deployedProcessApplication", (Object)deployedProcessApplication);
        Map<String, DeployedProcessArchive> deploymentMap = deployedProcessApplication.getProcessArchiveDeploymentMap();
        if (deploymentMap != null) {
            List<ProcessesXml> processesXmls = deployedProcessApplication.getProcessesXmls();
            for (ProcessesXml processesXml : processesXmls) {
                for (ProcessArchiveXml parsedProcessArchive : processesXml.getProcessArchives()) {
                    DeployedProcessArchive deployedProcessArchive = deploymentMap.get(parsedProcessArchive.getName());
                    if (deployedProcessArchive == null) continue;
                    operationContext.addStep(new UndeployProcessArchiveStep(deployedProcessApplication, parsedProcessArchive, deployedProcessArchive.getProcessEngineName()));
                }
            }
        }
    }
}

