/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.deployment.jobexecutor;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.container.impl.jmx.services.JmxManagedJobExecutor;
import io.openbpm.bpm.container.impl.metadata.PropertyHelper;
import io.openbpm.bpm.container.impl.metadata.spi.JobAcquisitionXml;
import io.openbpm.bpm.container.impl.spi.DeploymentOperation;
import io.openbpm.bpm.container.impl.spi.DeploymentOperationStep;
import io.openbpm.bpm.container.impl.spi.PlatformServiceContainer;
import io.openbpm.bpm.container.impl.spi.ServiceTypes;
import io.openbpm.bpm.engine.ProcessEngineConfiguration;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutor;
import io.openbpm.bpm.engine.impl.jobexecutor.RuntimeContainerJobExecutor;
import java.util.Map;

public class StartJobAcquisitionStep
extends DeploymentOperationStep {
    protected static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected final JobAcquisitionXml jobAcquisitionXml;

    public StartJobAcquisitionStep(JobAcquisitionXml jobAcquisitionXml) {
        this.jobAcquisitionXml = jobAcquisitionXml;
    }

    @Override
    public String getName() {
        return "Start job acquisition '" + this.jobAcquisitionXml.getName() + "'";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        ClassLoader configurationClassloader = null;
        configurationClassloader = processApplication != null ? processApplication.getProcessApplicationClassloader() : ProcessEngineConfiguration.class.getClassLoader();
        String configurationClassName = this.jobAcquisitionXml.getJobExecutorClassName();
        if (configurationClassName == null || configurationClassName.isEmpty()) {
            configurationClassName = RuntimeContainerJobExecutor.class.getName();
        }
        Class<? extends JobExecutor> jobExecutorClass = this.loadJobExecutorClass(configurationClassloader, configurationClassName);
        JobExecutor jobExecutor = this.instantiateJobExecutor(jobExecutorClass);
        Map<String, String> properties = this.jobAcquisitionXml.getProperties();
        PropertyHelper.applyProperties(jobExecutor, properties);
        JmxManagedJobExecutor jmxManagedJobExecutor = new JmxManagedJobExecutor(jobExecutor);
        serviceContainer.startService(ServiceTypes.JOB_EXECUTOR, this.jobAcquisitionXml.getName(), jmxManagedJobExecutor);
    }

    protected JobExecutor instantiateJobExecutor(Class<? extends JobExecutor> configurationClass) {
        try {
            return configurationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw LOG.couldNotInstantiateJobExecutorClass(e);
        }
    }

    protected Class<? extends JobExecutor> loadJobExecutorClass(ClassLoader processApplicationClassloader, String jobExecutorClassname) {
        try {
            return processApplicationClassloader.loadClass(jobExecutorClassname);
        }
        catch (ClassNotFoundException e) {
            throw LOG.couldNotLoadJobExecutorClass(e);
        }
    }
}

