/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.deployment.util;

import io.openbpm.bpm.application.AbstractProcessApplication;
import io.openbpm.bpm.application.ProcessApplicationDeploymentInfo;
import io.openbpm.bpm.application.ProcessApplicationInfo;
import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import io.openbpm.bpm.container.impl.spi.DeploymentOperation;
import io.openbpm.bpm.container.impl.spi.PlatformServiceContainer;
import io.openbpm.bpm.container.impl.spi.ServiceTypes;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class InjectionUtil {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    private InjectionUtil() {
    }

    public static Method detectAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotationType) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            for (Annotation annotaiton : method.getAnnotations()) {
                if (!annotationType.equals(annotaiton.annotationType())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object[] resolveInjections(DeploymentOperation operationContext, Method lifecycleMethod) {
        Type[] parameterTypes = lifecycleMethod.getGenericParameterTypes();
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Type parameterType : parameterTypes) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            boolean injectionResolved = false;
            if (parameterType instanceof Class) {
                Class parameterClass = (Class)parameterType;
                if (ProcessEngine.class.isAssignableFrom(parameterClass)) {
                    parameters.add(InjectionUtil.getDefaultProcessEngine(operationContext));
                    injectionResolved = true;
                } else if (ProcessApplicationInfo.class.isAssignableFrom(parameterClass)) {
                    parameters.add(InjectionUtil.getProcessApplicationInfo(operationContext));
                    injectionResolved = true;
                }
            } else if (parameterType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)parameterType).getActualTypeArguments()).length == 1 && ProcessEngine.class.isAssignableFrom((Class)actualTypeArguments[0])) {
                parameters.add(InjectionUtil.getProcessEngines(operationContext));
                injectionResolved = true;
            }
            if (injectionResolved) continue;
            throw LOG.unsuppoertedParameterType(parameterType);
        }
        return parameters.toArray();
    }

    public static ProcessApplicationInfo getProcessApplicationInfo(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        JmxManagedProcessApplication managedPa = (JmxManagedProcessApplication)serviceContainer.getServiceValue(ServiceTypes.PROCESS_APPLICATION, processApplication.getName());
        return managedPa.getProcessApplicationInfo();
    }

    public static List<ProcessEngine> getProcessEngines(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        ProcessApplicationInfo processApplicationInfo = InjectionUtil.getProcessApplicationInfo(operationContext);
        ArrayList<ProcessEngine> processEngines = new ArrayList<ProcessEngine>();
        for (ProcessApplicationDeploymentInfo deploymentInfo : processApplicationInfo.getDeploymentInfo()) {
            String processEngineName = deploymentInfo.getProcessEngineName();
            processEngines.add((ProcessEngine)serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, processEngineName));
        }
        return processEngines;
    }

    public static ProcessEngine getDefaultProcessEngine(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        return (ProcessEngine)serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, "default");
    }
}

