/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.container.impl.jmx;

import io.openbpm.bpm.container.impl.ContainerIntegrationLogger;
import io.openbpm.bpm.container.impl.spi.DeploymentOperation;
import io.openbpm.bpm.container.impl.spi.PlatformService;
import io.openbpm.bpm.container.impl.spi.PlatformServiceContainer;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MBeanServiceContainer
implements PlatformServiceContainer {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected MBeanServer mBeanServer;
    protected Map<ObjectName, PlatformService<?>> servicesByName = new ConcurrentHashMap();
    protected ThreadLocal<Stack<DeploymentOperation>> activeDeploymentOperations = new ThreadLocal();
    public static final String SERVICE_NAME_EXECUTOR = "executor-service";

    @Override
    public synchronized <S> void startService(PlatformServiceContainer.ServiceType serviceType, String localName, PlatformService<S> service) {
        String serviceName = MBeanServiceContainer.composeLocalName(serviceType, localName);
        this.startService(serviceName, service);
    }

    @Override
    public synchronized <S> void startService(String name, PlatformService<S> service) {
        ObjectName serviceName = MBeanServiceContainer.getObjectName(name);
        if (this.getService(serviceName) != null) {
            throw new ProcessEngineException("Cannot register service " + String.valueOf(serviceName) + " with MBeans Container, service with same name already registered.");
        }
        MBeanServer beanServer = this.getmBeanServer();
        service.start(this);
        try {
            beanServer.registerMBean(service, serviceName);
            this.servicesByName.put(serviceName, service);
            Stack<DeploymentOperation> currentOperationContext = this.activeDeploymentOperations.get();
            if (currentOperationContext != null) {
                currentOperationContext.peek().serviceAdded(name);
            }
        }
        catch (Exception e) {
            throw LOG.cannotRegisterService(serviceName, e);
        }
    }

    public static ObjectName getObjectName(String serviceName) {
        try {
            return new ObjectName(serviceName);
        }
        catch (Exception e) {
            throw LOG.cannotComposeNameFor(serviceName, e);
        }
    }

    public static String composeLocalName(PlatformServiceContainer.ServiceType type, String localName) {
        return type.getTypeName() + ":type=" + localName;
    }

    @Override
    public synchronized void stopService(PlatformServiceContainer.ServiceType serviceType, String localName) {
        String globalName = MBeanServiceContainer.composeLocalName(serviceType, localName);
        this.stopService(globalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopService(String name) {
        MBeanServer beanServer = this.getmBeanServer();
        ObjectName serviceName = MBeanServiceContainer.getObjectName(name);
        PlatformService service = (PlatformService)this.getService(serviceName);
        EnsureUtil.ensureNotNull("Cannot stop service " + String.valueOf(serviceName) + ": no such service registered", "service", (Object)service);
        ProcessEngineException unregisteringServiceException = null;
        try {
            service.stop(this);
        }
        finally {
            try {
                beanServer.unregisterMBean(serviceName);
                this.servicesByName.remove(serviceName);
            }
            catch (Exception e) {
                unregisteringServiceException = LOG.exceptionWhileUnregisteringService(serviceName.getCanonicalName(), e);
            }
        }
        if (null != unregisteringServiceException) {
            throw unregisteringServiceException;
        }
    }

    @Override
    public DeploymentOperation.DeploymentOperationBuilder createDeploymentOperation(String name) {
        return new DeploymentOperation.DeploymentOperationBuilder(this, name);
    }

    @Override
    public DeploymentOperation.DeploymentOperationBuilder createUndeploymentOperation(String name) {
        DeploymentOperation.DeploymentOperationBuilder builder = new DeploymentOperation.DeploymentOperationBuilder(this, name);
        builder.setUndeploymentOperation();
        return builder;
    }

    @Override
    public void executeDeploymentOperation(DeploymentOperation operation) {
        Stack<DeploymentOperation> currentOperationContext = this.activeDeploymentOperations.get();
        if (currentOperationContext == null) {
            currentOperationContext = new Stack();
            this.activeDeploymentOperations.set(currentOperationContext);
        }
        try {
            currentOperationContext.push(operation);
            operation.execute();
        }
        finally {
            currentOperationContext.pop();
            if (currentOperationContext.isEmpty()) {
                this.activeDeploymentOperations.remove();
            }
        }
    }

    @Override
    public <S> S getService(PlatformServiceContainer.ServiceType type, String localName) {
        String globalName = MBeanServiceContainer.composeLocalName(type, localName);
        ObjectName serviceName = MBeanServiceContainer.getObjectName(globalName);
        return this.getService(serviceName);
    }

    public <S> S getService(ObjectName name) {
        return (S)this.servicesByName.get(name);
    }

    public <S> S getServiceValue(ObjectName name) {
        PlatformService service = (PlatformService)this.getService(name);
        if (service != null) {
            return service.getValue();
        }
        return null;
    }

    @Override
    public <S> S getServiceValue(PlatformServiceContainer.ServiceType type, String localName) {
        String globalName = MBeanServiceContainer.composeLocalName(type, localName);
        ObjectName serviceName = MBeanServiceContainer.getObjectName(globalName);
        return this.getServiceValue(serviceName);
    }

    @Override
    public <S> List<PlatformService<S>> getServicesByType(PlatformServiceContainer.ServiceType type) {
        Set<String> serviceNames = this.getServiceNames(type);
        ArrayList<PlatformService<S>> res = new ArrayList<PlatformService<S>>();
        for (String serviceName : serviceNames) {
            res.add(this.servicesByName.get(MBeanServiceContainer.getObjectName(serviceName)));
        }
        return res;
    }

    @Override
    public Set<String> getServiceNames(PlatformServiceContainer.ServiceType type) {
        String typeName = MBeanServiceContainer.composeLocalName(type, "*");
        ObjectName typeObjectName = MBeanServiceContainer.getObjectName(typeName);
        Set<ObjectName> resultNames = this.getmBeanServer().queryNames(typeObjectName, null);
        HashSet<String> result = new HashSet<String>();
        for (ObjectName objectName : resultNames) {
            result.add(objectName.toString());
        }
        return result;
    }

    @Override
    public <S> List<S> getServiceValuesByType(PlatformServiceContainer.ServiceType type) {
        Set<String> serviceNames = this.getServiceNames(type);
        ArrayList res = new ArrayList();
        for (String serviceName : serviceNames) {
            PlatformService<?> bpmPlatformService = this.servicesByName.get(MBeanServiceContainer.getObjectName(serviceName));
            if (bpmPlatformService == null) continue;
            res.add(bpmPlatformService.getValue());
        }
        return res;
    }

    public synchronized MBeanServer getmBeanServer() {
        if (this.mBeanServer == null) {
            this.mBeanServer = this.createOrLookupMbeanServer();
        }
        return this.mBeanServer;
    }

    public synchronized void setmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    protected MBeanServer createOrLookupMbeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

