/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.AuthorizationService;
import io.openbpm.bpm.engine.authorization.Authorization;
import io.openbpm.bpm.engine.authorization.AuthorizationQuery;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.impl.AuthorizationQueryImpl;
import io.openbpm.bpm.engine.impl.ServiceImpl;
import io.openbpm.bpm.engine.impl.cmd.AuthorizationCheckCmd;
import io.openbpm.bpm.engine.impl.cmd.CreateAuthorizationCommand;
import io.openbpm.bpm.engine.impl.cmd.DeleteAuthorizationCmd;
import io.openbpm.bpm.engine.impl.cmd.SaveAuthorizationCmd;
import java.util.List;

public class AuthorizationServiceImpl
extends ServiceImpl
implements AuthorizationService {
    @Override
    public AuthorizationQuery createAuthorizationQuery() {
        return new AuthorizationQueryImpl(this.commandExecutor);
    }

    @Override
    public Authorization createNewAuthorization(int type) {
        return this.commandExecutor.execute(new CreateAuthorizationCommand(type));
    }

    @Override
    public Authorization saveAuthorization(Authorization authorization) {
        return this.commandExecutor.execute(new SaveAuthorizationCmd(authorization));
    }

    @Override
    public void deleteAuthorization(String authorizationId) {
        this.commandExecutor.execute(new DeleteAuthorizationCmd(authorizationId));
    }

    @Override
    public boolean isUserAuthorized(String userId, List<String> groupIds, Permission permission, Resource resource) {
        return this.commandExecutor.execute(new AuthorizationCheckCmd(userId, groupIds, permission, resource, null));
    }

    @Override
    public boolean isUserAuthorized(String userId, List<String> groupIds, Permission permission, Resource resource, String resourceId) {
        return this.commandExecutor.execute(new AuthorizationCheckCmd(userId, groupIds, permission, resource, resourceId));
    }
}

