/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.history.CleanableHistoricDecisionInstanceReport;
import io.openbpm.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.CleanableHistoricInstanceReportProperty;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.Date;
import java.util.List;

public class CleanableHistoricDecisionInstanceReportImpl
extends AbstractQuery<CleanableHistoricDecisionInstanceReport, CleanableHistoricDecisionInstanceReportResult>
implements CleanableHistoricDecisionInstanceReport {
    private static final long serialVersionUID = 1L;
    protected String[] decisionDefinitionIdIn;
    protected String[] decisionDefinitionKeyIn;
    protected String[] tenantIdIn;
    protected boolean isTenantIdSet;
    protected boolean isCompact;
    protected Date currentTimestamp;
    protected boolean isHistoryCleanupStrategyRemovalTimeBased;

    public CleanableHistoricDecisionInstanceReportImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public CleanableHistoricDecisionInstanceReport decisionDefinitionIdIn(String ... decisionDefinitionIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "decisionDefinitionIdIn", (Object[])decisionDefinitionIds);
        this.decisionDefinitionIdIn = decisionDefinitionIds;
        return this;
    }

    @Override
    public CleanableHistoricDecisionInstanceReport decisionDefinitionKeyIn(String ... decisionDefinitionKeys) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "decisionDefinitionKeyIn", (Object[])decisionDefinitionKeys);
        this.decisionDefinitionKeyIn = decisionDefinitionKeys;
        return this;
    }

    @Override
    public CleanableHistoricDecisionInstanceReport tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, "", "tenantIdIn", (Object[])tenantIds);
        this.tenantIdIn = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public CleanableHistoricDecisionInstanceReport withoutTenantId() {
        this.tenantIdIn = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public CleanableHistoricDecisionInstanceReport compact() {
        this.isCompact = true;
        return this;
    }

    @Override
    public CleanableHistoricDecisionInstanceReport orderByFinished() {
        this.orderBy(CleanableHistoricInstanceReportProperty.FINISHED_AMOUNT);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.provideHistoryCleanupStrategy(commandContext);
        this.checkQueryOk();
        return commandContext.getHistoricDecisionInstanceManager().findCleanableHistoricDecisionInstancesReportCountByCriteria(this);
    }

    @Override
    public List<CleanableHistoricDecisionInstanceReportResult> executeList(CommandContext commandContext, Page page) {
        this.provideHistoryCleanupStrategy(commandContext);
        this.checkQueryOk();
        return commandContext.getHistoricDecisionInstanceManager().findCleanableHistoricDecisionInstancesReportByCriteria(this, page);
    }

    public String[] getDecisionDefinitionIdIn() {
        return this.decisionDefinitionIdIn;
    }

    public void setDecisionDefinitionIdIn(String[] decisionDefinitionIdIn) {
        this.decisionDefinitionIdIn = decisionDefinitionIdIn;
    }

    public String[] getDecisionDefinitionKeyIn() {
        return this.decisionDefinitionKeyIn;
    }

    public void setDecisionDefinitionKeyIn(String[] decisionDefinitionKeyIn) {
        this.decisionDefinitionKeyIn = decisionDefinitionKeyIn;
    }

    public Date getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public void setCurrentTimestamp(Date currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
    }

    public String[] getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(String[] tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    public boolean isCompact() {
        return this.isCompact;
    }

    protected void provideHistoryCleanupStrategy(CommandContext commandContext) {
        String historyCleanupStrategy = commandContext.getProcessEngineConfiguration().getHistoryCleanupStrategy();
        this.isHistoryCleanupStrategyRemovalTimeBased = "removalTimeBased".equals(historyCleanupStrategy);
    }

    public boolean isHistoryCleanupStrategyRemovalTimeBased() {
        return this.isHistoryCleanupStrategyRemovalTimeBased;
    }
}

