/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.form.FormData;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.AbstractGetDeployedFormCmd;
import io.openbpm.bpm.engine.impl.cmd.GetTaskFormCmd;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class GetDeployedTaskFormCmd
extends AbstractGetDeployedFormCmd {
    protected String taskId;

    public GetDeployedTaskFormCmd(String taskId) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Task id cannot be null", "taskId", (Object)taskId);
        this.taskId = taskId;
    }

    @Override
    protected FormData getFormData() {
        return this.commandContext.runWithoutAuthorization(new GetTaskFormCmd(this.taskId));
    }

    @Override
    protected void checkAuthorization() {
        TaskEntity taskEntity = this.commandContext.getTaskManager().findTaskById(this.taskId);
        for (CommandChecker checker : this.commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadTask(taskEntity);
        }
    }
}

