/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.identity.Group;
import io.openbpm.bpm.engine.identity.GroupQuery;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.GroupQueryProperty;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public abstract class GroupQueryImpl
extends AbstractQuery<GroupQuery, Group>
implements GroupQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] ids;
    protected String name;
    protected String nameLike;
    protected String type;
    protected String userId;
    protected String procDefId;
    protected String tenantId;

    protected GroupQueryImpl() {
    }

    protected GroupQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public GroupQuery groupId(String id) {
        EnsureUtil.ensureNotNull("Provided id", (Object)id);
        this.id = id;
        return this;
    }

    @Override
    public GroupQuery groupIdIn(String ... ids) {
        EnsureUtil.ensureNotNull("Provided ids", (Object[])ids);
        this.ids = ids;
        return this;
    }

    @Override
    public GroupQuery groupName(String name) {
        EnsureUtil.ensureNotNull("Provided name", (Object)name);
        this.name = name;
        return this;
    }

    @Override
    public GroupQuery groupNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("Provided nameLike", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public GroupQuery groupType(String type) {
        EnsureUtil.ensureNotNull("Provided type", (Object)type);
        this.type = type;
        return this;
    }

    @Override
    public GroupQuery groupMember(String userId) {
        EnsureUtil.ensureNotNull("Provided userId", (Object)userId);
        this.userId = userId;
        return this;
    }

    @Override
    public GroupQuery potentialStarter(String procDefId) {
        EnsureUtil.ensureNotNull("Provided processDefinitionId", (Object)procDefId);
        this.procDefId = procDefId;
        return this;
    }

    @Override
    public GroupQuery memberOfTenant(String tenantId) {
        EnsureUtil.ensureNotNull("Provided tenantId", (Object)tenantId);
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public GroupQuery orderByGroupId() {
        return (GroupQuery)this.orderBy(GroupQueryProperty.GROUP_ID);
    }

    @Override
    public GroupQuery orderByGroupName() {
        return (GroupQuery)this.orderBy(GroupQueryProperty.NAME);
    }

    @Override
    public GroupQuery orderByGroupType() {
        return (GroupQuery)this.orderBy(GroupQueryProperty.TYPE);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String[] getIds() {
        return this.ids;
    }
}

