/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.history.HistoricCaseActivityStatistics;
import io.openbpm.bpm.engine.history.HistoricCaseActivityStatisticsQuery;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.List;

public class HistoricCaseActivityStatisticsQueryImpl
extends AbstractQuery<HistoricCaseActivityStatisticsQuery, HistoricCaseActivityStatistics>
implements HistoricCaseActivityStatisticsQuery {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;

    public HistoricCaseActivityStatisticsQueryImpl(String caseDefinitionId, CommandExecutor commandExecutor) {
        super(commandExecutor);
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricStatisticsManager().getHistoricStatisticsCountGroupedByCaseActivity(this);
    }

    @Override
    public List<HistoricCaseActivityStatistics> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricStatisticsManager().getHistoricStatisticsGroupedByCaseActivity(this, page);
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        EnsureUtil.ensureNotNull("No valid case definition id supplied", "caseDefinitionId", (Object)this.caseDefinitionId);
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }
}

