/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.history.DurationReportResult;
import io.openbpm.bpm.engine.history.HistoricTaskInstanceReport;
import io.openbpm.bpm.engine.history.HistoricTaskInstanceReportResult;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.TenantCheck;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.query.PeriodUnit;
import java.util.Date;
import java.util.List;

public class HistoricTaskInstanceReportImpl
implements HistoricTaskInstanceReport {
    protected Date completedAfter;
    protected Date completedBefore;
    protected PeriodUnit durationPeriodUnit;
    protected CommandExecutor commandExecutor;
    protected TenantCheck tenantCheck = new TenantCheck();

    public HistoricTaskInstanceReportImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public List<HistoricTaskInstanceReportResult> countByProcessDefinitionKey() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return this.commandExecutor.execute(new HistoricTaskInstanceCountByProcessDefinitionKey());
        }
        return this.executeCountByProcessDefinitionKey(commandContext);
    }

    protected List<HistoricTaskInstanceReportResult> executeCountByProcessDefinitionKey(CommandContext commandContext) {
        return commandContext.getTaskReportManager().selectHistoricTaskInstanceCountByProcDefKeyReport(this);
    }

    @Override
    public List<HistoricTaskInstanceReportResult> countByTaskName() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return this.commandExecutor.execute(new HistoricTaskInstanceCountByNameCmd());
        }
        return this.executeCountByTaskName(commandContext);
    }

    protected List<HistoricTaskInstanceReportResult> executeCountByTaskName(CommandContext commandContext) {
        return commandContext.getTaskReportManager().selectHistoricTaskInstanceCountByTaskNameReport(this);
    }

    @Override
    public List<DurationReportResult> duration(PeriodUnit periodUnit) {
        EnsureUtil.ensureNotNull(NotValidException.class, "periodUnit", (Object)periodUnit);
        this.durationPeriodUnit = periodUnit;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return this.commandExecutor.execute(new ExecuteDurationCmd());
        }
        return this.executeDuration(commandContext);
    }

    protected List<DurationReportResult> executeDuration(CommandContext commandContext) {
        return commandContext.getTaskReportManager().createHistoricTaskDurationReport(this);
    }

    public Date getCompletedAfter() {
        return this.completedAfter;
    }

    public Date getCompletedBefore() {
        return this.completedBefore;
    }

    @Override
    public HistoricTaskInstanceReport completedAfter(Date completedAfter) {
        EnsureUtil.ensureNotNull(NotValidException.class, "completedAfter", (Object)completedAfter);
        this.completedAfter = completedAfter;
        return this;
    }

    @Override
    public HistoricTaskInstanceReport completedBefore(Date completedBefore) {
        EnsureUtil.ensureNotNull(NotValidException.class, "completedBefore", (Object)completedBefore);
        this.completedBefore = completedBefore;
        return this;
    }

    public TenantCheck getTenantCheck() {
        return this.tenantCheck;
    }

    public String getReportPeriodUnitName() {
        return this.durationPeriodUnit.name();
    }

    protected class HistoricTaskInstanceCountByProcessDefinitionKey
    implements Command<List<HistoricTaskInstanceReportResult>> {
        protected HistoricTaskInstanceCountByProcessDefinitionKey() {
        }

        @Override
        public List<HistoricTaskInstanceReportResult> execute(CommandContext commandContext) {
            return HistoricTaskInstanceReportImpl.this.executeCountByProcessDefinitionKey(commandContext);
        }
    }

    protected class HistoricTaskInstanceCountByNameCmd
    implements Command<List<HistoricTaskInstanceReportResult>> {
        protected HistoricTaskInstanceCountByNameCmd() {
        }

        @Override
        public List<HistoricTaskInstanceReportResult> execute(CommandContext commandContext) {
            return HistoricTaskInstanceReportImpl.this.executeCountByTaskName(commandContext);
        }
    }

    protected class ExecuteDurationCmd
    implements Command<List<DurationReportResult>> {
        protected ExecuteDurationCmd() {
        }

        @Override
        public List<DurationReportResult> execute(CommandContext commandContext) {
            return HistoricTaskInstanceReportImpl.this.executeDuration(commandContext);
        }
    }
}

