/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import io.openbpm.bpm.engine.impl.cmd.ActivityAfterInstantiationCmd;
import io.openbpm.bpm.engine.impl.cmd.ActivityBeforeInstantiationCmd;
import io.openbpm.bpm.engine.impl.cmd.ActivityCancellationCmd;
import io.openbpm.bpm.engine.impl.cmd.ProcessInstanceModificationBatchCmd;
import io.openbpm.bpm.engine.impl.cmd.ProcessInstanceModificationCmd;
import io.openbpm.bpm.engine.impl.cmd.TransitionInstantiationCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.ModificationBuilder;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ModificationBuilderImpl
implements ModificationBuilder {
    protected CommandExecutor commandExecutor;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected List<String> processInstanceIds;
    protected List<AbstractProcessInstanceModificationCommand> instructions;
    protected String processDefinitionId;
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;
    protected String annotation;

    public ModificationBuilderImpl(CommandExecutor commandExecutor, String processDefinitionId) {
        this.commandExecutor = commandExecutor;
        EnsureUtil.ensureNotNull(NotValidException.class, "processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        this.processInstanceIds = new ArrayList<String>();
        this.instructions = new ArrayList<AbstractProcessInstanceModificationCommand>();
    }

    @Override
    public ModificationBuilder startBeforeActivity(String activityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        this.instructions.add(new ActivityBeforeInstantiationCmd(activityId));
        return this;
    }

    @Override
    public ModificationBuilder startAfterActivity(String activityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        this.instructions.add(new ActivityAfterInstantiationCmd(activityId));
        return this;
    }

    @Override
    public ModificationBuilder startTransition(String transitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "transitionId", (Object)transitionId);
        this.instructions.add(new TransitionInstantiationCmd(transitionId));
        return this;
    }

    @Override
    public ModificationBuilder cancelAllForActivity(String activityId) {
        return this.cancelAllForActivity(activityId, false);
    }

    @Override
    public ModificationBuilder cancelAllForActivity(String activityId, boolean cancelCurrentActiveActivityInstances) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        ActivityCancellationCmd activityCancellationCmd = new ActivityCancellationCmd(activityId);
        activityCancellationCmd.setCancelCurrentActiveActivityInstances(cancelCurrentActiveActivityInstances);
        this.instructions.add(activityCancellationCmd);
        return this;
    }

    @Override
    public ModificationBuilder processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public ModificationBuilder processInstanceIds(String ... processInstanceIds) {
        this.processInstanceIds = processInstanceIds == null ? Collections.emptyList() : Arrays.asList(processInstanceIds);
        return this;
    }

    @Override
    public ModificationBuilder processInstanceQuery(ProcessInstanceQuery processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Override
    public ModificationBuilder historicProcessInstanceQuery(HistoricProcessInstanceQuery historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Override
    public ModificationBuilder skipCustomListeners() {
        this.skipCustomListeners = true;
        return this;
    }

    @Override
    public ModificationBuilder skipIoMappings() {
        this.skipIoMappings = true;
        return this;
    }

    @Override
    public ModificationBuilder setAnnotation(String annotation) {
        this.annotation = annotation;
        return this;
    }

    public void execute(boolean writeUserOperationLog) {
        this.commandExecutor.execute(new ProcessInstanceModificationCmd(this, writeUserOperationLog));
    }

    @Override
    public void execute() {
        this.execute(true);
    }

    @Override
    public Batch executeAsync() {
        return this.commandExecutor.execute(new ProcessInstanceModificationBatchCmd(this));
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public ProcessInstanceQuery getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public HistoricProcessInstanceQuery getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public List<AbstractProcessInstanceModificationCommand> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<AbstractProcessInstanceModificationCommand> instructions) {
        this.instructions = instructions;
    }

    public boolean isSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public boolean isSkipIoMappings() {
        return this.skipIoMappings;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotationInternal(String annotation) {
        this.annotation = annotation;
    }
}

