/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.AuthorizationService;
import io.openbpm.bpm.engine.CaseService;
import io.openbpm.bpm.engine.DecisionService;
import io.openbpm.bpm.engine.ExternalTaskService;
import io.openbpm.bpm.engine.FilterService;
import io.openbpm.bpm.engine.FormService;
import io.openbpm.bpm.engine.HistoryService;
import io.openbpm.bpm.engine.IdentityService;
import io.openbpm.bpm.engine.ManagementService;
import io.openbpm.bpm.engine.OptimisticLockingException;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngines;
import io.openbpm.bpm.engine.RepositoryService;
import io.openbpm.bpm.engine.RuntimeService;
import io.openbpm.bpm.engine.TaskService;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.SchemaOperationProcessEngineClose;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.cfg.TransactionContextFactory;
import io.openbpm.bpm.engine.impl.el.ExpressionManager;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.SimpleIpBasedProvider;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.interceptor.SessionFactory;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutor;
import io.openbpm.bpm.engine.impl.metrics.reporter.DbMetricsReporter;
import io.openbpm.bpm.engine.impl.util.CompositeCondition;
import java.util.Map;

public class ProcessEngineImpl
implements ProcessEngine {
    public static final CompositeCondition EXT_TASK_CONDITIONS = new CompositeCondition();
    private static final ProcessEngineLogger LOG = ProcessEngineLogger.INSTANCE;
    protected String name;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected HistoryService historicDataService;
    protected IdentityService identityService;
    protected TaskService taskService;
    protected FormService formService;
    protected ManagementService managementService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;
    protected FilterService filterService;
    protected ExternalTaskService externalTaskService;
    protected DecisionService decisionService;
    protected String databaseSchemaUpdate;
    protected JobExecutor jobExecutor;
    protected CommandExecutor commandExecutor;
    protected CommandExecutor commandExecutorSchemaOperations;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected ExpressionManager expressionManager;
    protected HistoryLevel historyLevel;
    protected TransactionContextFactory transactionContextFactory;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.name = processEngineConfiguration.getProcessEngineName();
        this.repositoryService = processEngineConfiguration.getRepositoryService();
        this.runtimeService = processEngineConfiguration.getRuntimeService();
        this.historicDataService = processEngineConfiguration.getHistoryService();
        this.identityService = processEngineConfiguration.getIdentityService();
        this.taskService = processEngineConfiguration.getTaskService();
        this.formService = processEngineConfiguration.getFormService();
        this.managementService = processEngineConfiguration.getManagementService();
        this.authorizationService = processEngineConfiguration.getAuthorizationService();
        this.caseService = processEngineConfiguration.getCaseService();
        this.filterService = processEngineConfiguration.getFilterService();
        this.externalTaskService = processEngineConfiguration.getExternalTaskService();
        this.decisionService = processEngineConfiguration.getDecisionService();
        this.databaseSchemaUpdate = processEngineConfiguration.getDatabaseSchemaUpdate();
        this.jobExecutor = processEngineConfiguration.getJobExecutor();
        this.commandExecutor = processEngineConfiguration.getCommandExecutorTxRequired();
        this.commandExecutorSchemaOperations = processEngineConfiguration.getCommandExecutorSchemaOperations();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.historyLevel = processEngineConfiguration.getHistoryLevel();
        this.transactionContextFactory = processEngineConfiguration.getTransactionContextFactory();
        this.executeSchemaOperations();
        if (this.name == null) {
            LOG.processEngineCreated("default");
        } else {
            LOG.processEngineCreated(this.name);
        }
        ProcessEngines.registerProcessEngine(this);
        if (this.jobExecutor != null) {
            this.jobExecutor.registerProcessEngine(this);
        }
        if (processEngineConfiguration.isMetricsEnabled()) {
            String reporterId = processEngineConfiguration.getMetricsReporterIdProvider() != null && processEngineConfiguration.getHostnameProvider() instanceof SimpleIpBasedProvider ? processEngineConfiguration.getMetricsReporterIdProvider().provideId(this) : processEngineConfiguration.getHostname();
            DbMetricsReporter dbMetricsReporter = processEngineConfiguration.getDbMetricsReporter();
            dbMetricsReporter.setReporterId(reporterId);
            if (processEngineConfiguration.isDbMetricsReporterActivate()) {
                dbMetricsReporter.start();
            }
        }
    }

    protected void executeSchemaOperations() {
        this.commandExecutorSchemaOperations.execute(this.processEngineConfiguration.getSchemaOperationsCommand());
        this.commandExecutorSchemaOperations.execute(this.processEngineConfiguration.getHistoryLevelCommand());
        try {
            this.commandExecutorSchemaOperations.execute(this.processEngineConfiguration.getProcessEngineBootstrapCommand());
        }
        catch (OptimisticLockingException ole) {
            LOG.historyCleanupJobReconfigurationFailure(ole);
        }
    }

    @Override
    public void close() {
        ProcessEngines.unregister(this);
        if (this.processEngineConfiguration.isMetricsEnabled()) {
            this.processEngineConfiguration.getDbMetricsReporter().stop();
        }
        if (this.jobExecutor != null) {
            this.jobExecutor.unregisterProcessEngine(this);
        }
        this.commandExecutorSchemaOperations.execute(new SchemaOperationProcessEngineClose());
        this.processEngineConfiguration.close();
        LOG.processEngineClosed(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    @Override
    public IdentityService getIdentityService() {
        return this.identityService;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public TaskService getTaskService() {
        return this.taskService;
    }

    @Override
    public HistoryService getHistoryService() {
        return this.historicDataService;
    }

    @Override
    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    @Override
    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public FormService getFormService() {
        return this.formService;
    }

    @Override
    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    @Override
    public CaseService getCaseService() {
        return this.caseService;
    }

    @Override
    public FilterService getFilterService() {
        return this.filterService;
    }

    @Override
    public ExternalTaskService getExternalTaskService() {
        return this.externalTaskService;
    }

    @Override
    public DecisionService getDecisionService() {
        return this.decisionService;
    }
}

