/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.engine.RepositoryService;
import io.openbpm.bpm.engine.exception.DeploymentResourceNotFoundException;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.exception.NullValueException;
import io.openbpm.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import io.openbpm.bpm.engine.exception.cmmn.CmmnModelInstanceNotFoundException;
import io.openbpm.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import io.openbpm.bpm.engine.exception.dmn.DmnModelInstanceNotFoundException;
import io.openbpm.bpm.engine.impl.DeploymentQueryImpl;
import io.openbpm.bpm.engine.impl.ProcessDefinitionQueryImpl;
import io.openbpm.bpm.engine.impl.ServiceImpl;
import io.openbpm.bpm.engine.impl.cmd.AddIdentityLinkForProcessDefinitionCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteDeploymentCmd;
import io.openbpm.bpm.engine.impl.cmd.DeleteIdentityLinkForProcessDefinitionCmd;
import io.openbpm.bpm.engine.impl.cmd.DeployCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeployedProcessDefinitionCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentBpmnModelInstanceCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentProcessDiagramCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentProcessDiagramLayoutCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentProcessModelCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentResourceForIdCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentResourceNamesCmd;
import io.openbpm.bpm.engine.impl.cmd.GetDeploymentResourcesCmd;
import io.openbpm.bpm.engine.impl.cmd.GetIdentityLinksForProcessDefinitionCmd;
import io.openbpm.bpm.engine.impl.cmd.GetStaticCalledProcessDefinitionCmd;
import io.openbpm.bpm.engine.impl.cmd.UpdateDecisionDefinitionHistoryTimeToLiveCmd;
import io.openbpm.bpm.engine.impl.cmd.UpdateProcessDefinitionHistoryTimeToLiveCmd;
import io.openbpm.bpm.engine.impl.cmmn.cmd.GetDeploymentCaseDefinitionCmd;
import io.openbpm.bpm.engine.impl.cmmn.cmd.GetDeploymentCaseDiagramCmd;
import io.openbpm.bpm.engine.impl.cmmn.cmd.GetDeploymentCaseModelCmd;
import io.openbpm.bpm.engine.impl.cmmn.cmd.GetDeploymentCmmnModelInstanceCmd;
import io.openbpm.bpm.engine.impl.cmmn.cmd.UpdateCaseDefinitionHistoryTimeToLiveCmd;
import io.openbpm.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import io.openbpm.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionDefinitionCmd;
import io.openbpm.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionDiagramCmd;
import io.openbpm.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionModelCmd;
import io.openbpm.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionRequirementsDefinitionCmd;
import io.openbpm.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionRequirementsDiagramCmd;
import io.openbpm.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionRequirementsModelCmd;
import io.openbpm.bpm.engine.impl.dmn.cmd.GetDeploymentDmnModelInstanceCmd;
import io.openbpm.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import io.openbpm.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionQueryImpl;
import io.openbpm.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import io.openbpm.bpm.engine.impl.repository.DeleteProcessDefinitionsBuilderImpl;
import io.openbpm.bpm.engine.impl.repository.DeploymentBuilderImpl;
import io.openbpm.bpm.engine.impl.repository.ProcessApplicationDeploymentBuilderImpl;
import io.openbpm.bpm.engine.impl.repository.UpdateProcessDefinitionSuspensionStateBuilderImpl;
import io.openbpm.bpm.engine.repository.CalledProcessDefinition;
import io.openbpm.bpm.engine.repository.CaseDefinition;
import io.openbpm.bpm.engine.repository.CaseDefinitionQuery;
import io.openbpm.bpm.engine.repository.DecisionDefinition;
import io.openbpm.bpm.engine.repository.DecisionDefinitionQuery;
import io.openbpm.bpm.engine.repository.DecisionRequirementsDefinition;
import io.openbpm.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import io.openbpm.bpm.engine.repository.DeleteProcessDefinitionsBuilder;
import io.openbpm.bpm.engine.repository.DeleteProcessDefinitionsSelectBuilder;
import io.openbpm.bpm.engine.repository.DeploymentBuilder;
import io.openbpm.bpm.engine.repository.DeploymentQuery;
import io.openbpm.bpm.engine.repository.DeploymentWithDefinitions;
import io.openbpm.bpm.engine.repository.DiagramLayout;
import io.openbpm.bpm.engine.repository.ProcessApplicationDeploymentBuilder;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import io.openbpm.bpm.engine.repository.ProcessDefinitionQuery;
import io.openbpm.bpm.engine.repository.Resource;
import io.openbpm.bpm.engine.repository.UpdateProcessDefinitionSuspensionStateSelectBuilder;
import io.openbpm.bpm.engine.task.IdentityLink;
import io.openbpm.bpm.model.bpmn.BpmnModelInstance;
import io.openbpm.bpm.model.cmmn.CmmnModelInstance;
import io.openbpm.bpm.model.dmn.DmnModelInstance;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RepositoryServiceImpl
extends ServiceImpl
implements RepositoryService {
    protected Charset deploymentCharset;

    public Charset getDeploymentCharset() {
        return this.deploymentCharset;
    }

    public void setDeploymentCharset(Charset deploymentCharset) {
        this.deploymentCharset = deploymentCharset;
    }

    @Override
    public DeploymentBuilder createDeployment() {
        return new DeploymentBuilderImpl(this);
    }

    @Override
    public ProcessApplicationDeploymentBuilder createDeployment(ProcessApplicationReference processApplication) {
        return new ProcessApplicationDeploymentBuilderImpl(this, processApplication);
    }

    public DeploymentWithDefinitions deployWithResult(DeploymentBuilderImpl deploymentBuilder) {
        return this.commandExecutor.execute(new DeployCmd(deploymentBuilder));
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId, false, false, false));
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId, cascade, false, false));
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade, boolean skipCustomListeners) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId, cascade, skipCustomListeners, false));
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId, cascade, skipCustomListeners, skipIoMappings));
    }

    @Override
    public void deleteProcessDefinition(String processDefinitionId) {
        this.deleteProcessDefinition(processDefinitionId, false);
    }

    @Override
    public void deleteProcessDefinition(String processDefinitionId, boolean cascade) {
        this.deleteProcessDefinition(processDefinitionId, cascade, false);
    }

    @Override
    public void deleteProcessDefinition(String processDefinitionId, boolean cascade, boolean skipCustomListeners) {
        this.deleteProcessDefinition(processDefinitionId, cascade, skipCustomListeners, false);
    }

    @Override
    public void deleteProcessDefinition(String processDefinitionId, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        DeleteProcessDefinitionsBuilder builder = this.deleteProcessDefinitions().byIds(processDefinitionId);
        if (cascade) {
            builder.cascade();
        }
        if (skipCustomListeners) {
            builder.skipCustomListeners();
        }
        if (skipIoMappings) {
            builder.skipIoMappings();
        }
        builder.delete();
    }

    @Override
    public DeleteProcessDefinitionsSelectBuilder deleteProcessDefinitions() {
        return new DeleteProcessDefinitionsBuilderImpl(this.commandExecutor);
    }

    @Override
    public ProcessDefinitionQuery createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public CaseDefinitionQuery createCaseDefinitionQuery() {
        return new CaseDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public DecisionDefinitionQuery createDecisionDefinitionQuery() {
        return new DecisionDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public DecisionRequirementsDefinitionQuery createDecisionRequirementsDefinitionQuery() {
        return new DecisionRequirementsDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.commandExecutor.execute(new GetDeploymentResourceNamesCmd(deploymentId));
    }

    @Override
    public List<Resource> getDeploymentResources(String deploymentId) {
        return this.commandExecutor.execute(new GetDeploymentResourcesCmd(deploymentId));
    }

    @Override
    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return this.commandExecutor.execute(new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    @Override
    public InputStream getResourceAsStreamById(String deploymentId, String resourceId) {
        return this.commandExecutor.execute(new GetDeploymentResourceForIdCmd(deploymentId, resourceId));
    }

    @Override
    public DeploymentQuery createDeploymentQuery() {
        return new DeploymentQueryImpl(this.commandExecutor);
    }

    @Override
    public ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeployedProcessDefinitionCmd(processDefinitionId, true));
    }

    public ReadOnlyProcessDefinition getDeployedProcessDefinition(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeployedProcessDefinitionCmd(processDefinitionId, true));
    }

    @Override
    public void suspendProcessDefinitionById(String processDefinitionId) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).suspend();
    }

    @Override
    public void suspendProcessDefinitionById(String processDefinitionId, boolean suspendProcessInstances, Date suspensionDate) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeProcessInstances(suspendProcessInstances).executionDate(suspensionDate).suspend();
    }

    @Override
    public void suspendProcessDefinitionByKey(String processDefinitionKey) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).suspend();
    }

    @Override
    public void suspendProcessDefinitionByKey(String processDefinitionKey, boolean suspendProcessInstances, Date suspensionDate) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeProcessInstances(suspendProcessInstances).executionDate(suspensionDate).suspend();
    }

    @Override
    public void activateProcessDefinitionById(String processDefinitionId) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).activate();
    }

    @Override
    public void activateProcessDefinitionById(String processDefinitionId, boolean activateProcessInstances, Date activationDate) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeProcessInstances(activateProcessInstances).executionDate(activationDate).activate();
    }

    @Override
    public void activateProcessDefinitionByKey(String processDefinitionKey) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).activate();
    }

    @Override
    public void activateProcessDefinitionByKey(String processDefinitionKey, boolean activateProcessInstances, Date activationDate) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeProcessInstances(activateProcessInstances).executionDate(activationDate).activate();
    }

    @Override
    public UpdateProcessDefinitionSuspensionStateSelectBuilder updateProcessDefinitionSuspensionState() {
        return new UpdateProcessDefinitionSuspensionStateBuilderImpl(this.commandExecutor);
    }

    @Override
    public void updateProcessDefinitionHistoryTimeToLive(String processDefinitionId, Integer historyTimeToLive) {
        this.commandExecutor.execute(new UpdateProcessDefinitionHistoryTimeToLiveCmd(processDefinitionId, historyTimeToLive));
    }

    @Override
    public void updateDecisionDefinitionHistoryTimeToLive(String decisionDefinitionId, Integer historyTimeToLive) {
        this.commandExecutor.execute(new UpdateDecisionDefinitionHistoryTimeToLiveCmd(decisionDefinitionId, historyTimeToLive));
    }

    @Override
    public void updateCaseDefinitionHistoryTimeToLive(String caseDefinitionId, Integer historyTimeToLive) {
        this.commandExecutor.execute(new UpdateCaseDefinitionHistoryTimeToLiveCmd(caseDefinitionId, historyTimeToLive));
    }

    @Override
    public InputStream getProcessModel(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentProcessModelCmd(processDefinitionId));
    }

    @Override
    public InputStream getProcessDiagram(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentProcessDiagramCmd(processDefinitionId));
    }

    @Override
    public InputStream getCaseDiagram(String caseDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentCaseDiagramCmd(caseDefinitionId));
    }

    @Override
    public DiagramLayout getProcessDiagramLayout(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentProcessDiagramLayoutCmd(processDefinitionId));
    }

    @Override
    public BpmnModelInstance getBpmnModelInstance(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentBpmnModelInstanceCmd(processDefinitionId));
    }

    @Override
    public CmmnModelInstance getCmmnModelInstance(String caseDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentCmmnModelInstanceCmd(caseDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException | CmmnModelInstanceNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public DmnModelInstance getDmnModelInstance(String decisionDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDmnModelInstanceCmd(decisionDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException | DmnModelInstanceNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public void addCandidateStarterUser(String processDefinitionId, String userId) {
        this.commandExecutor.execute(new AddIdentityLinkForProcessDefinitionCmd(processDefinitionId, userId, null));
    }

    @Override
    public void addCandidateStarterGroup(String processDefinitionId, String groupId) {
        this.commandExecutor.execute(new AddIdentityLinkForProcessDefinitionCmd(processDefinitionId, null, groupId));
    }

    @Override
    public void deleteCandidateStarterGroup(String processDefinitionId, String groupId) {
        this.commandExecutor.execute(new DeleteIdentityLinkForProcessDefinitionCmd(processDefinitionId, null, groupId));
    }

    @Override
    public void deleteCandidateStarterUser(String processDefinitionId, String userId) {
        this.commandExecutor.execute(new DeleteIdentityLinkForProcessDefinitionCmd(processDefinitionId, userId, null));
    }

    @Override
    public List<IdentityLink> getIdentityLinksForProcessDefinition(String processDefinitionId) {
        return this.commandExecutor.execute(new GetIdentityLinksForProcessDefinitionCmd(processDefinitionId));
    }

    @Override
    public CaseDefinition getCaseDefinition(String caseDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentCaseDefinitionCmd(caseDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (CaseDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream getCaseModel(String caseDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentCaseModelCmd(caseDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException | CaseDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public DecisionDefinition getDecisionDefinition(String decisionDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDecisionDefinitionCmd(decisionDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public DecisionRequirementsDefinition getDecisionRequirementsDefinition(String decisionRequirementsDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDecisionRequirementsDefinitionCmd(decisionRequirementsDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream getDecisionModel(String decisionDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDecisionModelCmd(decisionDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException | DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream getDecisionRequirementsModel(String decisionRequirementsDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDecisionRequirementsModelCmd(decisionRequirementsDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException | DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream getDecisionDiagram(String decisionDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentDecisionDiagramCmd(decisionDefinitionId));
    }

    @Override
    public InputStream getDecisionRequirementsDiagram(String decisionRequirementsDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentDecisionRequirementsDiagramCmd(decisionRequirementsDefinitionId));
    }

    @Override
    public Collection<CalledProcessDefinition> getStaticCalledProcessDefinitions(String processDefinitionId) {
        return this.commandExecutor.execute(new GetStaticCalledProcessDefinitionCmd(processDefinitionId));
    }
}

