/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl;

import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.cmd.UpdateProcessInstancesSuspendStateBatchCmd;
import io.openbpm.bpm.engine.impl.cmd.UpdateProcessInstancesSuspendStateCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.runtime.ProcessInstanceQuery;
import io.openbpm.bpm.engine.runtime.UpdateProcessInstancesSuspensionStateBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UpdateProcessInstancesSuspensionStateBuilderImpl
implements UpdateProcessInstancesSuspensionStateBuilder {
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected CommandExecutor commandExecutor;
    protected String processDefinitionId;

    public UpdateProcessInstancesSuspensionStateBuilderImpl(CommandExecutor commandExecutor) {
        this.processInstanceIds = new ArrayList<String>();
        this.commandExecutor = commandExecutor;
    }

    public UpdateProcessInstancesSuspensionStateBuilderImpl(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @Override
    public UpdateProcessInstancesSuspensionStateBuilder byProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds.addAll(processInstanceIds);
        return this;
    }

    @Override
    public UpdateProcessInstancesSuspensionStateBuilder byProcessInstanceIds(String ... processInstanceIds) {
        this.processInstanceIds.addAll(Arrays.asList(processInstanceIds));
        return this;
    }

    @Override
    public UpdateProcessInstancesSuspensionStateBuilder byProcessInstanceQuery(ProcessInstanceQuery processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Override
    public UpdateProcessInstancesSuspensionStateBuilder byHistoricProcessInstanceQuery(HistoricProcessInstanceQuery historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Override
    public void suspend() {
        this.commandExecutor.execute(new UpdateProcessInstancesSuspendStateCmd(this.commandExecutor, this, true));
    }

    @Override
    public void activate() {
        this.commandExecutor.execute(new UpdateProcessInstancesSuspendStateCmd(this.commandExecutor, this, false));
    }

    @Override
    public Batch suspendAsync() {
        return this.commandExecutor.execute(new UpdateProcessInstancesSuspendStateBatchCmd(this.commandExecutor, this, true));
    }

    @Override
    public Batch activateAsync() {
        return this.commandExecutor.execute(new UpdateProcessInstancesSuspendStateBatchCmd(this.commandExecutor, this, false));
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public ProcessInstanceQuery getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public HistoricProcessInstanceQuery getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }
}

