/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.batch;

import io.openbpm.bpm.engine.impl.batch.DeploymentMapping;
import io.openbpm.bpm.engine.impl.batch.DeploymentMappings;
import io.openbpm.bpm.engine.impl.util.ImmutablePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class BatchElementConfiguration {
    protected static final Comparator<String> NULLS_LAST_STRING_COMPARATOR = Comparator.nullsLast(String::compareToIgnoreCase);
    protected SortedMap<String, Set<String>> collectedMappings = new TreeMap<String, Set<String>>(NULLS_LAST_STRING_COMPARATOR);
    protected List<String> ids;
    protected DeploymentMappings mappings;

    public void addDeploymentMappings(List<ImmutablePair<String, String>> mappings) {
        this.addDeploymentMappings(mappings, null);
    }

    public void addDeploymentMappings(List<ImmutablePair<String, String>> mappingsList, Collection<String> idList) {
        if (this.ids != null) {
            this.ids = null;
            this.mappings = null;
        }
        HashSet<String> missingIds = idList == null ? null : new HashSet<String>(idList);
        mappingsList.forEach(pair -> {
            String deploymentId = (String)pair.getLeft();
            HashSet<String> idSet = (HashSet<String>)this.collectedMappings.get(deploymentId);
            if (idSet == null) {
                idSet = new HashSet<String>();
                this.collectedMappings.put(deploymentId, idSet);
            }
            idSet.add((String)pair.getRight());
            if (missingIds != null) {
                missingIds.remove(pair.getRight());
            }
        });
        if (missingIds != null && !missingIds.isEmpty()) {
            this.collectedMappings.computeIfAbsent(null, k -> new HashSet()).addAll(missingIds);
        }
    }

    public List<String> getIds() {
        if (this.ids == null) {
            this.createDeploymentMappings();
        }
        return this.ids;
    }

    public DeploymentMappings getMappings() {
        if (this.mappings == null) {
            this.createDeploymentMappings();
        }
        return this.mappings;
    }

    public boolean isEmpty() {
        return this.collectedMappings.isEmpty();
    }

    protected void createDeploymentMappings() {
        this.ids = new ArrayList<String>();
        this.mappings = new DeploymentMappings();
        for (Map.Entry<String, Set<String>> mapping : this.collectedMappings.entrySet()) {
            this.ids.addAll((Collection<String>)mapping.getValue());
            this.mappings.add(new DeploymentMapping(mapping.getKey(), mapping.getValue().size()));
        }
    }
}

