/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.batch.removaltime;

import io.openbpm.bpm.engine.impl.batch.BatchJobContext;
import io.openbpm.bpm.engine.impl.batch.removaltime.ProcessSetRemovalTimeJobHandler;
import io.openbpm.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import io.openbpm.bpm.engine.impl.cfg.TransactionListener;
import io.openbpm.bpm.engine.impl.db.DbEntity;
import io.openbpm.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import io.openbpm.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.MessageEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProcessSetRemovalTimeResultHandler
implements TransactionListener {
    protected SetRemovalTimeBatchConfiguration batchJobConfiguration;
    protected Integer chunkSize;
    protected CommandExecutor commandExecutor;
    protected ProcessSetRemovalTimeJobHandler jobHandler;
    protected String jobId;
    protected Map<Class<? extends DbEntity>, DbOperation> operations;

    public ProcessSetRemovalTimeResultHandler(SetRemovalTimeBatchConfiguration batchJobConfiguration, Integer chunkSize, CommandExecutor commandExecutor, ProcessSetRemovalTimeJobHandler jobHandler, String jobId, Map<Class<? extends DbEntity>, DbOperation> operations) {
        this.batchJobConfiguration = batchJobConfiguration;
        this.chunkSize = chunkSize;
        this.commandExecutor = commandExecutor;
        this.jobHandler = jobHandler;
        this.jobId = jobId;
        this.operations = operations;
    }

    @Override
    public void execute(CommandContext commandContext) {
        this.commandExecutor.execute((CommandContext context) -> {
            JobEntity job = context.getJobManager().findJobById(this.jobId);
            Set<String> entitiesToUpdate = ProcessSetRemovalTimeResultHandler.getEntitiesToUpdate(this.operations, this.chunkSize);
            if (entitiesToUpdate.isEmpty() && !this.operations.containsKey(HistoricProcessInstanceEventEntity.class)) {
                entitiesToUpdate = new HashSet<String>();
                entitiesToUpdate.add(HistoricProcessInstanceEventEntity.class.getName());
            }
            if (entitiesToUpdate.isEmpty()) {
                job.delete(true);
            } else {
                this.batchJobConfiguration.setEntities(entitiesToUpdate);
                ByteArrayEntity newConfiguration = this.saveConfiguration(this.batchJobConfiguration, context);
                BatchJobContext newBatchContext = new BatchJobContext(null, newConfiguration);
                ProcessSetRemovalTimeJobHandler.JOB_DECLARATION.reconfigure(newBatchContext, (MessageEntity)job);
                context.getJobManager().reschedule(job, ClockUtil.getCurrentTime());
            }
            return null;
        });
    }

    protected ByteArrayEntity saveConfiguration(SetRemovalTimeBatchConfiguration configuration, CommandContext context) {
        ByteArrayEntity configurationEntity = new ByteArrayEntity();
        configurationEntity.setBytes(this.jobHandler.writeConfiguration(configuration));
        context.getByteArrayManager().insert(configurationEntity);
        return configurationEntity;
    }

    protected static Set<String> getEntitiesToUpdate(Map<Class<? extends DbEntity>, DbOperation> operations, int chunkSize) {
        return operations.entrySet().stream().filter(op -> ((DbOperation)op.getValue()).getRowsAffected() == chunkSize).map(op -> ((Class)op.getKey()).getName()).collect(Collectors.toSet());
    }
}

