/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.batch.removaltime;

import io.openbpm.bpm.engine.impl.batch.AbstractBatchConfigurationObjectConverter;
import io.openbpm.bpm.engine.impl.batch.DeploymentMappingJsonConverter;
import io.openbpm.bpm.engine.impl.batch.DeploymentMappings;
import io.openbpm.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import io.openbpm.bpm.engine.impl.util.JsonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import openbpmjar.impl.com.google.gson.JsonObject;

public class SetRemovalTimeJsonConverter
extends AbstractBatchConfigurationObjectConverter<SetRemovalTimeBatchConfiguration> {
    public static final SetRemovalTimeJsonConverter INSTANCE = new SetRemovalTimeJsonConverter();
    protected static final String IDS = "ids";
    protected static final String ID_MAPPINGS = "idMappings";
    protected static final String REMOVAL_TIME = "removalTime";
    protected static final String HAS_REMOVAL_TIME = "hasRemovalTime";
    protected static final String IS_HIERARCHICAL = "isHierarchical";
    protected static final String UPDATE_IN_CHUNKS = "updateInChunks";
    protected static final String CHUNK_SIZE = "chunkSize";
    protected static final String ENTITIES = "entities";

    @Override
    public JsonObject writeConfiguration(SetRemovalTimeBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addListField(json, IDS, configuration.getIds());
        JsonUtil.addListField(json, ID_MAPPINGS, DeploymentMappingJsonConverter.INSTANCE, configuration.getIdMappings());
        JsonUtil.addDateField(json, REMOVAL_TIME, configuration.getRemovalTime());
        JsonUtil.addField(json, HAS_REMOVAL_TIME, configuration.hasRemovalTime());
        JsonUtil.addField(json, IS_HIERARCHICAL, configuration.isHierarchical());
        JsonUtil.addField(json, UPDATE_IN_CHUNKS, configuration.isUpdateInChunks());
        JsonUtil.addField(json, CHUNK_SIZE, configuration.getChunkSize());
        if (configuration.getEntities() != null) {
            JsonUtil.addListField(json, ENTITIES, new ArrayList<String>(configuration.getEntities()));
        }
        return json;
    }

    @Override
    public SetRemovalTimeBatchConfiguration readConfiguration(JsonObject jsonObject) {
        long removalTimeMills = JsonUtil.getLong(jsonObject, REMOVAL_TIME);
        Date removalTime = removalTimeMills > 0L ? new Date(removalTimeMills) : null;
        List<String> instanceIds = JsonUtil.asStringList(JsonUtil.getArray(jsonObject, IDS));
        DeploymentMappings mappings = JsonUtil.asList(JsonUtil.getArray(jsonObject, ID_MAPPINGS), DeploymentMappingJsonConverter.INSTANCE, DeploymentMappings::new);
        boolean hasRemovalTime = JsonUtil.getBoolean(jsonObject, HAS_REMOVAL_TIME);
        boolean isHierarchical = JsonUtil.getBoolean(jsonObject, IS_HIERARCHICAL);
        boolean updateInChunks = JsonUtil.getBoolean(jsonObject, UPDATE_IN_CHUNKS);
        Integer chunkSize = jsonObject.has(CHUNK_SIZE) ? Integer.valueOf(JsonUtil.getInt(jsonObject, CHUNK_SIZE)) : null;
        HashSet<String> entities = null;
        if (jsonObject.has(ENTITIES)) {
            entities = new HashSet<String>(JsonUtil.asStringList(JsonUtil.getArray(jsonObject, ENTITIES)));
        }
        return new SetRemovalTimeBatchConfiguration(instanceIds, mappings).setRemovalTime(removalTime).setHasRemovalTime(hasRemovalTime).setHierarchical(isHierarchical).setUpdateInChunks(updateInChunks).setChunkSize(chunkSize).setEntities(entities);
    }
}

