/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.behavior;

import io.openbpm.bpm.engine.impl.Condition;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import io.openbpm.bpm.engine.impl.pvm.PvmTransition;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import io.openbpm.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BpmnActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    public void performDefaultOutgoingBehavior(ActivityExecution activityExecution) {
        this.performOutgoingBehavior(activityExecution, true);
    }

    public void performIgnoreConditionsOutgoingBehavior(ActivityExecution activityExecution) {
        this.performOutgoingBehavior(activityExecution, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performOutgoingBehavior(ActivityExecution execution, boolean checkConditions) {
        LOG.leavingActivity(execution.getActivity().getId());
        String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
        ArrayList<PvmTransition> transitionsToTake = new ArrayList<PvmTransition>();
        List<PvmTransition> outgoingTransitions = execution.getActivity().getOutgoingTransitions();
        for (PvmTransition outgoingTransition : outgoingTransitions) {
            Condition condition;
            if (defaultSequenceFlow != null && outgoingTransition.getId().equals(defaultSequenceFlow) || (condition = (Condition)outgoingTransition.getProperty("condition")) != null && checkConditions && !condition.evaluate(execution)) continue;
            transitionsToTake.add(outgoingTransition);
        }
        if (transitionsToTake.size() == 1) {
            execution.leaveActivityViaTransition((PvmTransition)transitionsToTake.get(0));
            return;
        } else if (!transitionsToTake.isEmpty()) {
            execution.leaveActivityViaTransitions(transitionsToTake, Arrays.asList(execution));
            return;
        } else if (defaultSequenceFlow != null) {
            PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
            if (defaultTransition == null) throw LOG.missingDefaultFlowException(execution.getActivity().getId(), defaultSequenceFlow);
            execution.leaveActivityViaTransition(defaultTransition);
            return;
        } else {
            if (!outgoingTransitions.isEmpty()) {
                throw LOG.missingConditionalFlowException(execution.getActivity().getId());
            }
            if (((ActivityImpl)execution.getActivity()).isCompensationHandler() && this.isAncestorCompensationThrowing(execution)) {
                execution.endCompensation();
                return;
            } else {
                LOG.missingOutgoingSequenceFlow(execution.getActivity().getId());
                execution.end(true);
            }
        }
    }

    protected boolean isAncestorCompensationThrowing(ActivityExecution execution) {
        for (ActivityExecution parent = execution.getParent(); parent != null; parent = parent.getParent()) {
            if (!CompensationBehavior.isCompensationThrowing((PvmExecutionImpl)parent)) continue;
            return true;
        }
        return false;
    }
}

