/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.behavior;

import io.openbpm.bpm.application.InvocationContext;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.engine.delegate.JavaDelegate;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.CustomActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.context.ProcessApplicationContextUtil;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import io.openbpm.bpm.engine.impl.util.ClassDelegateUtil;
import java.util.List;

public class ClassDelegateActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;

    public ClassDelegateActivityBehavior(String className, List<FieldDeclaration> fieldDeclarations) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
    }

    public ClassDelegateActivityBehavior(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this(clazz.getName(), fieldDeclarations);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        this.executeWithErrorPropagation(execution, () -> {
            this.getActivityBehaviorInstance(execution).execute(execution);
            return null;
        });
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(() -> {
                this.signal(execution, signalName, signalData);
                return null;
            }, targetProcessApplication, new InvocationContext(execution));
        } else {
            this.doSignal(execution, signalName, signalData);
        }
    }

    protected void doSignal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        CustomActivityBehavior behavior;
        ActivityBehavior delegate;
        ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
        if (activityBehaviorInstance instanceof CustomActivityBehavior && !((delegate = (behavior = (CustomActivityBehavior)activityBehaviorInstance).getDelegateActivityBehavior()) instanceof SignallableActivityBehavior)) {
            throw LOG.incorrectlyUsedSignalException(SignallableActivityBehavior.class.getName());
        }
        this.executeWithErrorPropagation(execution, () -> {
            ((SignallableActivityBehavior)activityBehaviorInstance).signal(execution, signalName, signalData);
            return null;
        });
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution) {
        Object delegateInstance = ClassDelegateUtil.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            ActivityBehavior activityBehavior = (ActivityBehavior)delegateInstance;
            return new CustomActivityBehavior(activityBehavior);
        }
        if (delegateInstance instanceof JavaDelegate) {
            JavaDelegate javaDelegate = (JavaDelegate)delegateInstance;
            return new ServiceTaskJavaDelegateActivityBehavior(javaDelegate);
        }
        throw LOG.missingDelegateParentClassException(delegateInstance.getClass().getName(), JavaDelegate.class.getName(), ActivityBehavior.class.getName());
    }
}

