/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.behavior;

import io.openbpm.bpm.engine.impl.Condition;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import io.openbpm.bpm.engine.impl.pvm.PvmTransition;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import java.util.Iterator;

public class ExclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doLeave(ActivityExecution execution) {
        LOG.leavingActivity(execution.getActivity().getId());
        PvmTransition outgoingSeqFlow = null;
        String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
        Iterator<PvmTransition> transitionIterator = execution.getActivity().getOutgoingTransitions().iterator();
        while (outgoingSeqFlow == null && transitionIterator.hasNext()) {
            PvmTransition seqFlow = transitionIterator.next();
            Condition condition = (Condition)seqFlow.getProperty("condition");
            if ((condition != null || defaultSequenceFlow != null && defaultSequenceFlow.equals(seqFlow.getId())) && (condition == null || !condition.evaluate(execution))) continue;
            LOG.outgoingSequenceFlowSelected(seqFlow.getId());
            outgoingSeqFlow = seqFlow;
        }
        if (outgoingSeqFlow != null) {
            execution.leaveActivityViaTransition(outgoingSeqFlow);
            return;
        } else {
            if (defaultSequenceFlow == null) throw LOG.stuckExecutionException(execution.getActivity().getId());
            PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
            if (defaultTransition == null) throw LOG.missingDefaultFlowException(execution.getActivity().getId(), defaultSequenceFlow);
            execution.leaveActivityViaTransition(defaultTransition);
        }
    }
}

