/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.behavior;

import io.openbpm.bpm.application.InvocationContext;
import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.delegate.JavaDelegate;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.CustomActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.delegate.ActivityBehaviorInvocation;
import io.openbpm.bpm.engine.impl.bpmn.delegate.JavaDelegateInvocation;
import io.openbpm.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.context.ProcessApplicationContextUtil;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import io.openbpm.bpm.engine.impl.util.ClassDelegateUtil;
import java.util.List;
import java.util.concurrent.Callable;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public ServiceTaskDelegateExpressionActivityBehavior(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(() -> {
                this.signal(execution, signalName, signalData);
                return null;
            }, targetProcessApplication, new InvocationContext(execution));
        } else {
            this.doSignal(execution, signalName, signalData);
        }
    }

    public void doSignal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        CustomActivityBehavior behavior;
        ActivityBehavior delegateActivityBehavior;
        Object delegate = this.expression.getValue(execution);
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution, delegate);
        if (activityBehaviorInstance instanceof CustomActivityBehavior && !((delegateActivityBehavior = (behavior = (CustomActivityBehavior)activityBehaviorInstance).getDelegateActivityBehavior()) instanceof SignallableActivityBehavior)) {
            return;
        }
        this.executeWithErrorPropagation(execution, () -> {
            ((SignallableActivityBehavior)activityBehaviorInstance).signal(execution, signalName, signalData);
            return null;
        });
    }

    @Override
    public void performExecution(ActivityExecution execution) throws Exception {
        Callable<Void> callable = () -> {
            Object delegate = this.expression.getValue(execution);
            ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
            if (delegate instanceof ActivityBehavior) {
                ActivityBehavior activityBehavior = (ActivityBehavior)delegate;
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation(activityBehavior, execution));
            } else if (delegate instanceof JavaDelegate) {
                JavaDelegate javaDelegate = (JavaDelegate)delegate;
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation(javaDelegate, execution));
                this.leave(execution);
            } else {
                throw LOG.resolveDelegateExpressionException(this.expression, ActivityBehavior.class, JavaDelegate.class);
            }
            return null;
        };
        this.executeWithErrorPropagation(execution, callable);
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution, Object delegateInstance) {
        if (delegateInstance instanceof ActivityBehavior) {
            ActivityBehavior activityBehavior = (ActivityBehavior)delegateInstance;
            return new CustomActivityBehavior(activityBehavior);
        }
        if (delegateInstance instanceof JavaDelegate) {
            JavaDelegate javaDelegate = (JavaDelegate)delegateInstance;
            return new ServiceTaskJavaDelegateActivityBehavior(javaDelegate);
        }
        throw LOG.missingDelegateParentClassException(delegateInstance.getClass().getName(), JavaDelegate.class.getName(), ActivityBehavior.class.getName());
    }
}

