/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.helper;

import io.openbpm.bpm.engine.impl.bpmn.helper.BpmnProperties;
import io.openbpm.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import io.openbpm.bpm.engine.impl.pvm.PvmActivity;
import io.openbpm.bpm.engine.impl.pvm.PvmScope;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.impl.tree.TreeVisitor;
import java.util.List;

public class ErrorDeclarationForProcessInstanceFinder
implements TreeVisitor<PvmScope> {
    protected Exception exception;
    protected String errorCode;
    protected PvmActivity errorHandlerActivity;
    protected ErrorEventDefinition errorEventDefinition;
    protected PvmActivity currentActivity;

    public ErrorDeclarationForProcessInstanceFinder(Exception exception, String errorCode, PvmActivity currentActivity) {
        this.exception = exception;
        this.errorCode = errorCode;
        this.currentActivity = currentActivity;
    }

    @Override
    public void visit(PvmScope scope) {
        List<ErrorEventDefinition> errorEventDefinitions = scope.getProperties().get(BpmnProperties.ERROR_EVENT_DEFINITIONS);
        for (ErrorEventDefinition definition : errorEventDefinitions) {
            PvmActivity activityHandler = scope.getProcessDefinition().findActivity(definition.getHandlerActivityId());
            if (this.isReThrowingErrorEventSubprocess(activityHandler) || (this.exception == null || !definition.catchesException(this.exception)) && (this.exception != null || !definition.catchesError(this.errorCode))) continue;
            this.errorHandlerActivity = activityHandler;
            this.errorEventDefinition = definition;
            break;
        }
    }

    protected boolean isReThrowingErrorEventSubprocess(PvmActivity activityHandler) {
        ScopeImpl activityHandlerScope = (ScopeImpl)((Object)activityHandler);
        return activityHandlerScope.isAncestorFlowScopeOf((ScopeImpl)((Object)this.currentActivity));
    }

    public PvmActivity getErrorHandlerActivity() {
        return this.errorHandlerActivity;
    }

    public ErrorEventDefinition getErrorEventDefinition() {
        return this.errorEventDefinition;
    }
}

