/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.bpmn.listener;

import io.openbpm.bpm.engine.delegate.DelegateExecution;
import io.openbpm.bpm.engine.delegate.ExecutionListener;
import io.openbpm.bpm.engine.delegate.JavaDelegate;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import io.openbpm.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.delegate.ExecutionListenerInvocation;
import io.openbpm.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.delegate.ClassDelegate;
import io.openbpm.bpm.engine.impl.util.ClassDelegateUtil;
import java.util.List;

public class ClassDelegateExecutionListener
extends ClassDelegate
implements ExecutionListener {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    public ClassDelegateExecutionListener(String className, List<FieldDeclaration> fieldDeclarations) {
        super(className, fieldDeclarations);
    }

    public ClassDelegateExecutionListener(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        super(clazz, fieldDeclarations);
    }

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        ExecutionListener executionListenerInstance = this.getExecutionListenerInstance();
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(executionListenerInstance, execution));
    }

    protected ExecutionListener getExecutionListenerInstance() {
        Object delegateInstance = ClassDelegateUtil.instantiateDelegate(this.className, (List<FieldDeclaration>)this.fieldDeclarations);
        if (delegateInstance instanceof ExecutionListener) {
            ExecutionListener executionListener = (ExecutionListener)delegateInstance;
            return executionListener;
        }
        if (delegateInstance instanceof JavaDelegate) {
            JavaDelegate javaDelegate = (JavaDelegate)delegateInstance;
            return new ServiceTaskJavaDelegateActivityBehavior(javaDelegate);
        }
        throw LOG.missingDelegateParentClassException(delegateInstance.getClass().getName(), ExecutionListener.class.getName(), JavaDelegate.class.getName());
    }
}

