/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.calendar;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.calendar.BusinessCalendar;
import io.openbpm.bpm.engine.impl.calendar.CronTimer;
import io.openbpm.bpm.engine.impl.calendar.DurationHelper;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import io.openbpm.bpm.engine.impl.util.EngineUtilLogger;
import io.openbpm.bpm.engine.task.Task;
import java.util.Date;

public class CycleBusinessCalendar
implements BusinessCalendar {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    public static final String NAME = "cycle";

    @Override
    public Date resolveDuedate(String duedateDescription, Task task) {
        return this.resolveDuedate(duedateDescription);
    }

    @Override
    public Date resolveDuedate(String duedateDescription) {
        return this.resolveDuedate(duedateDescription, (Date)null);
    }

    @Override
    public Date resolveDuedate(String duedateDescription, Date startDate) {
        return this.resolveDuedate(duedateDescription, startDate, 0L);
    }

    public Date resolveDuedate(String duedateDescription, Date startDate, long repeatOffset) {
        try {
            if (duedateDescription.startsWith("R")) {
                DurationHelper durationHelper = new DurationHelper(duedateDescription, startDate);
                durationHelper.setRepeatOffset(repeatOffset);
                return durationHelper.getDateAfter(startDate);
            }
            CronTimer cronTimer = CronTimer.parse(duedateDescription);
            return cronTimer.getDueDate(startDate == null ? ClockUtil.getCurrentTime() : startDate);
        }
        catch (Exception e) {
            throw LOG.exceptionWhileParsingCycleExpresison(duedateDescription, e);
        }
    }
}

