/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cfg;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.ConfigurationLogger;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import java.text.ParseException;
import java.util.Date;

public class BatchWindowConfiguration {
    protected static final ConfigurationLogger LOG = ProcessEngineLogger.CONFIG_LOGGER;
    private String startTime;
    private Date startTimeAsDate;
    private String endTime = "00:00";
    private Date endTimeAsDate;

    public BatchWindowConfiguration() {
    }

    public BatchWindowConfiguration(String startTime, String endTime) {
        this.startTime = startTime;
        this.initStartTimeAsDate();
        if (endTime != null) {
            this.endTime = endTime;
        }
        this.initEndTimeAsDate();
    }

    private void initStartTimeAsDate() {
        try {
            this.startTimeAsDate = HistoryCleanupHelper.parseTimeConfiguration(this.startTime);
        }
        catch (ParseException e) {
            throw LOG.invalidPropertyValue("startTime", this.startTime);
        }
    }

    private void initEndTimeAsDate() {
        try {
            this.endTimeAsDate = HistoryCleanupHelper.parseTimeConfiguration(this.endTime);
        }
        catch (ParseException e) {
            throw LOG.invalidPropertyValue("endTime", this.endTime);
        }
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
        this.initStartTimeAsDate();
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
        this.initEndTimeAsDate();
    }

    public Date getStartTimeAsDate() {
        return this.startTimeAsDate;
    }

    public Date getEndTimeAsDate() {
        return this.endTimeAsDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchWindowConfiguration that = (BatchWindowConfiguration)o;
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return this.endTime != null ? this.endTime.equals(that.endTime) : that.endTime == null;
    }

    public int hashCode() {
        int result = this.startTime != null ? this.startTime.hashCode() : 0;
        return 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
    }
}

