/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cfg.standalone;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.TransactionContext;
import io.openbpm.bpm.engine.impl.cfg.TransactionListener;
import io.openbpm.bpm.engine.impl.cfg.TransactionLogger;
import io.openbpm.bpm.engine.impl.cfg.TransactionState;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.PersistenceSession;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class StandaloneTransactionContext
implements TransactionContext {
    private static final TransactionLogger LOG = ProcessEngineLogger.TX_LOGGER;
    protected CommandContext commandContext;
    protected Map<TransactionState, List<TransactionListener>> stateTransactionListeners;
    private TransactionState lastTransactionState;

    public StandaloneTransactionContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener) {
        if (this.stateTransactionListeners == null) {
            this.stateTransactionListeners = new EnumMap<TransactionState, List<TransactionListener>>(TransactionState.class);
        }
        this.stateTransactionListeners.computeIfAbsent(transactionState, k -> new ArrayList()).add(transactionListener);
    }

    @Override
    public void commit() {
        LOG.debugTransactionOperation("firing event committing...");
        this.fireTransactionEvent(TransactionState.COMMITTING);
        LOG.debugTransactionOperation("committing the persistence session...");
        this.getPersistenceProvider().commit();
        LOG.debugTransactionOperation("firing event committed...");
        this.fireTransactionEvent(TransactionState.COMMITTED);
    }

    protected void fireTransactionEvent(TransactionState transactionState) {
        this.setLastTransactionState(transactionState);
        if (this.stateTransactionListeners == null) {
            return;
        }
        List<TransactionListener> transactionListeners = this.stateTransactionListeners.get((Object)transactionState);
        if (transactionListeners == null) {
            return;
        }
        for (TransactionListener transactionListener : transactionListeners) {
            transactionListener.execute(this.commandContext);
        }
    }

    protected void setLastTransactionState(TransactionState transactionState) {
        this.lastTransactionState = transactionState;
    }

    private PersistenceSession getPersistenceProvider() {
        return this.commandContext.getSession(PersistenceSession.class);
    }

    @Override
    public void rollback() {
        try {
            try {
                LOG.debugTransactionOperation("firing event rollback...");
                this.fireTransactionEvent(TransactionState.ROLLINGBACK);
                LOG.debugTransactionOperation("rolling back the persistence session...");
                this.getPersistenceProvider().rollback();
            }
            catch (Throwable exception) {
                try {
                    LOG.exceptionWhileFiringEvent(TransactionState.ROLLINGBACK, exception);
                    Context.getCommandInvocationContext().trySetThrowable(exception);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    LOG.debugTransactionOperation("rolling back the persistence session...");
                    this.getPersistenceProvider().rollback();
                }
            }
        }
        catch (Throwable exception) {
            LOG.exceptionWhileFiringEvent(TransactionState.ROLLINGBACK, exception);
            Context.getCommandInvocationContext().trySetThrowable(exception);
        }
        finally {
            LOG.debugFiringEventRolledBack();
            this.fireTransactionEvent(TransactionState.ROLLED_BACK);
        }
    }

    @Override
    public boolean isTransactionActive() {
        return !TransactionState.ROLLINGBACK.equals((Object)this.lastTransactionState) && !TransactionState.ROLLED_BACK.equals((Object)this.lastTransactionState);
    }
}

