/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cmd.AbstractSetJobDefinitionStateCmd;
import io.openbpm.bpm.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import io.openbpm.bpm.engine.impl.cmd.AbstractSetStateCmd;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import io.openbpm.bpm.engine.impl.jobexecutor.TimerChangeProcessDefinitionSuspensionStateJobHandler;
import io.openbpm.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.SuspensionState;
import io.openbpm.bpm.engine.impl.repository.UpdateProcessDefinitionSuspensionStateBuilderImpl;
import io.openbpm.bpm.engine.impl.runtime.UpdateProcessInstanceSuspensionStateBuilderImpl;
import java.util.Arrays;

public abstract class AbstractSetProcessDefinitionStateCmd
extends AbstractSetStateCmd {
    public static final String INCLUDE_PROCESS_INSTANCES_PROPERTY = "includeProcessInstances";
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String tenantId;
    protected boolean isTenantIdSet;

    protected AbstractSetProcessDefinitionStateCmd(UpdateProcessDefinitionSuspensionStateBuilderImpl builder) {
        super(builder.isIncludeProcessInstances(), builder.getExecutionDate());
        this.processDefinitionId = builder.getProcessDefinitionId();
        this.processDefinitionKey = builder.getProcessDefinitionKey();
        this.isTenantIdSet = builder.isTenantIdSet();
        this.tenantId = builder.getProcessDefinitionTenantId();
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Process definition id / key cannot be null");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            if (this.processDefinitionId != null) {
                checker.checkUpdateProcessDefinitionSuspensionStateById(this.processDefinitionId);
                if (!this.includeSubResources) continue;
                checker.checkUpdateProcessInstanceSuspensionStateByProcessDefinitionId(this.processDefinitionId);
                continue;
            }
            if (this.processDefinitionKey == null) continue;
            checker.checkUpdateProcessDefinitionSuspensionStateByKey(this.processDefinitionKey);
            if (!this.includeSubResources) continue;
            checker.checkUpdateProcessInstanceSuspensionStateByProcessDefinitionKey(this.processDefinitionKey);
        }
    }

    @Override
    protected void updateSuspensionState(CommandContext commandContext, SuspensionState suspensionState) {
        ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
        if (this.processDefinitionId != null) {
            processDefinitionManager.updateProcessDefinitionSuspensionStateById(this.processDefinitionId, suspensionState);
        } else if (this.isTenantIdSet) {
            processDefinitionManager.updateProcessDefinitionSuspensionStateByKeyAndTenantId(this.processDefinitionKey, this.tenantId, suspensionState);
        } else {
            processDefinitionManager.updateProcessDefinitionSuspensionStateByKey(this.processDefinitionKey, suspensionState);
        }
        commandContext.runWithoutAuthorization(() -> {
            UpdateJobDefinitionSuspensionStateBuilderImpl jobDefinitionSuspensionStateBuilder = this.createJobDefinitionCommandBuilder();
            AbstractSetJobDefinitionStateCmd jobDefinitionCmd = this.getSetJobDefinitionStateCmd(jobDefinitionSuspensionStateBuilder);
            jobDefinitionCmd.disableLogUserOperation();
            jobDefinitionCmd.execute(commandContext);
            return null;
        });
    }

    protected UpdateJobDefinitionSuspensionStateBuilderImpl createJobDefinitionCommandBuilder() {
        UpdateJobDefinitionSuspensionStateBuilderImpl jobDefinitionBuilder = new UpdateJobDefinitionSuspensionStateBuilderImpl();
        if (this.processDefinitionId != null) {
            jobDefinitionBuilder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            jobDefinitionBuilder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.isTenantIdSet && this.tenantId != null) {
                jobDefinitionBuilder.processDefinitionTenantId(this.tenantId);
            } else if (this.isTenantIdSet) {
                jobDefinitionBuilder.processDefinitionWithoutTenantId();
            }
        }
        return jobDefinitionBuilder;
    }

    protected UpdateProcessInstanceSuspensionStateBuilderImpl createProcessInstanceCommandBuilder() {
        UpdateProcessInstanceSuspensionStateBuilderImpl processInstanceBuilder = new UpdateProcessInstanceSuspensionStateBuilderImpl();
        if (this.processDefinitionId != null) {
            processInstanceBuilder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            processInstanceBuilder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.isTenantIdSet && this.tenantId != null) {
                processInstanceBuilder.processDefinitionTenantId(this.tenantId);
            } else if (this.isTenantIdSet) {
                processInstanceBuilder.processDefinitionWithoutTenantId();
            }
        }
        return processInstanceBuilder;
    }

    @Override
    protected JobHandlerConfiguration getJobHandlerConfiguration() {
        if (this.processDefinitionId != null) {
            return TimerChangeProcessDefinitionSuspensionStateJobHandler.ProcessDefinitionSuspensionStateConfiguration.byProcessDefinitionId(this.processDefinitionId, this.isIncludeSubResources());
        }
        if (this.isTenantIdSet) {
            return TimerChangeProcessDefinitionSuspensionStateJobHandler.ProcessDefinitionSuspensionStateConfiguration.byProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.tenantId, this.isIncludeSubResources());
        }
        return TimerChangeProcessDefinitionSuspensionStateJobHandler.ProcessDefinitionSuspensionStateConfiguration.byProcessDefinitionKey(this.processDefinitionKey, this.isIncludeSubResources());
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange suspensionStateChanged = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        PropertyChange includeProcessInstances = new PropertyChange(INCLUDE_PROCESS_INSTANCES_PROPERTY, null, this.isIncludeSubResources());
        commandContext.getOperationLogManager().logProcessDefinitionOperation(this.getLogEntryOperation(), this.processDefinitionId, this.processDefinitionKey, Arrays.asList(suspensionStateChanged, includeProcessInstances));
    }

    @Override
    protected abstract String getDelayedExecutionJobHandlerType();

    protected abstract AbstractSetJobDefinitionStateCmd getSetJobDefinitionStateCmd(UpdateJobDefinitionSuspensionStateBuilderImpl var1);

    @Override
    protected AbstractSetProcessInstanceStateCmd getNextCommand() {
        UpdateProcessInstanceSuspensionStateBuilderImpl processInstanceCommandBuilder = this.createProcessInstanceCommandBuilder();
        return this.getNextCommand(processInstanceCommandBuilder);
    }

    @Override
    protected String getDeploymentId(CommandContext commandContext) {
        if (this.processDefinitionId != null) {
            return this.getDeploymentIdByProcessDefinition(commandContext, this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            return this.getDeploymentIdByProcessDefinitionKey(commandContext, this.processDefinitionKey, this.isTenantIdSet, this.tenantId);
        }
        return null;
    }

    protected abstract AbstractSetProcessInstanceStateCmd getNextCommand(UpdateProcessInstanceSuspensionStateBuilderImpl var1);
}

