/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.db.DbEntity;
import io.openbpm.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import io.openbpm.bpm.engine.impl.db.entitymanager.OptimisticLockingResult;
import io.openbpm.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import io.openbpm.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.AcquiredJobs;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutor;
import io.openbpm.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

public class AcquireJobsCmd
implements Command<AcquiredJobs>,
OptimisticLockingListener {
    private final JobExecutor jobExecutor;
    protected AcquiredJobs acquiredJobs;
    protected int numJobsToAcquire;

    public AcquireJobsCmd(JobExecutor jobExecutor) {
        this(jobExecutor, jobExecutor.getMaxJobsPerAcquisition());
    }

    public AcquireJobsCmd(JobExecutor jobExecutor, int numJobsToAcquire) {
        this.jobExecutor = jobExecutor;
        this.numJobsToAcquire = numJobsToAcquire;
    }

    @Override
    public AcquiredJobs execute(CommandContext commandContext) {
        this.acquiredJobs = new AcquiredJobs(this.numJobsToAcquire);
        List<AcquirableJobEntity> jobs = commandContext.getJobManager().findNextJobsToExecute(new Page(0, this.numJobsToAcquire));
        HashMap<String, List> exclusiveJobsByProcessInstance = new HashMap<String, List>();
        boolean isAcquireExclusiveOverProcessHierarchies = this.isAcquireExclusiveOverProcessHierarchies(commandContext);
        for (AcquirableJobEntity job : jobs) {
            this.lockJob(job);
            if (job.isExclusive()) {
                String processInstanceId = this.selectProcessInstanceId(job, isAcquireExclusiveOverProcessHierarchies);
                List list = exclusiveJobsByProcessInstance.computeIfAbsent(processInstanceId, key -> new ArrayList());
                list.add(job.getId());
                continue;
            }
            this.acquiredJobs.addJobIdBatch(job.getId());
        }
        for (List jobIds : exclusiveJobsByProcessInstance.values()) {
            this.acquiredJobs.addJobIdBatch(jobIds);
        }
        commandContext.getDbEntityManager().registerOptimisticLockingListener(this);
        return this.acquiredJobs;
    }

    protected void lockJob(AcquirableJobEntity job) {
        String lockOwner = this.jobExecutor.getLockOwner();
        job.setLockOwner(lockOwner);
        int lockTimeInMillis = this.jobExecutor.getLockTimeInMillis();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(ClockUtil.getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }

    @Override
    public Class<? extends DbEntity> getEntityType() {
        return AcquirableJobEntity.class;
    }

    @Override
    public OptimisticLockingResult failedOperation(DbOperation operation) {
        if (operation instanceof DbEntityOperation) {
            DbEntityOperation entityOperation = (DbEntityOperation)operation;
            this.acquiredJobs.removeJobId(entityOperation.getEntity().getId());
            return OptimisticLockingResult.IGNORE;
        }
        return OptimisticLockingResult.THROW;
    }

    protected boolean isAcquireExclusiveOverProcessHierarchies(CommandContext context) {
        ProcessEngineConfigurationImpl engineConfig = context.getProcessEngineConfiguration();
        return engineConfig != null && engineConfig.isJobExecutorAcquireExclusiveOverProcessHierarchies();
    }

    protected String selectProcessInstanceId(AcquirableJobEntity job, boolean isAcquireExclusiveOverProcessHierarchies) {
        if (isAcquireExclusiveOverProcessHierarchies && job.getRootProcessInstanceId() != null) {
            return job.getRootProcessInstanceId();
        }
        return job.getProcessInstanceId();
    }
}

