/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import io.openbpm.bpm.engine.impl.core.model.CoreModelElement;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;

public class ActivityBeforeInstantiationCmd
extends AbstractInstantiationCmd {
    protected String activityId;

    public ActivityBeforeInstantiationCmd(String activityId) {
        this(null, activityId);
    }

    public ActivityBeforeInstantiationCmd(String processInstanceId, String activityId) {
        this(processInstanceId, activityId, null);
    }

    public ActivityBeforeInstantiationCmd(String processInstanceId, String activityId, String ancestorActivityInstanceId) {
        super(processInstanceId, ancestorActivityInstanceId);
        this.activityId = activityId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        ProcessDefinitionEntity processDefinition = processInstance.getProcessDefinition();
        ActivityImpl activity = processDefinition.findActivity(this.activityId);
        if (activity != null && "compensationBoundaryCatch".equals(activity.getProperty("type"))) {
            throw new ProcessEngineException("Cannot start before activity " + this.activityId + "; activity is a compensation boundary event.");
        }
        return super.execute(commandContext);
    }

    @Override
    protected ScopeImpl getTargetFlowScope(ProcessDefinitionImpl processDefinition) {
        ActivityImpl activity = processDefinition.findActivity(this.activityId);
        return activity.getFlowScope();
    }

    @Override
    protected CoreModelElement getTargetElement(ProcessDefinitionImpl processDefinition) {
        return processDefinition.findActivity(this.activityId);
    }

    @Override
    public String getTargetElementId() {
        return this.activityId;
    }

    @Override
    protected String describe() {
        StringBuilder sb = new StringBuilder();
        sb.append("Start before activity '");
        sb.append(this.activityId);
        sb.append("'");
        if (this.ancestorActivityInstanceId != null) {
            sb.append(" with ancestor activity instance '");
            sb.append(this.ancestorActivityInstanceId);
            sb.append("'");
        }
        return sb.toString();
    }
}

