/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.CommentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.task.Comment;
import java.io.Serializable;
import java.util.Date;

public class AddCommentCmd
implements Command<Comment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String processInstanceId;
    protected String message;

    public AddCommentCmd(String taskId, String processInstanceId, String message) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.message = message;
    }

    @Override
    public Comment execute(CommandContext commandContext) {
        if (this.processInstanceId == null && this.taskId == null) {
            throw new ProcessEngineException("Process instance id and task id is null");
        }
        EnsureUtil.ensureNotNull("Message", (Object)this.message);
        String userId = commandContext.getAuthenticatedUserId();
        CommentEntity comment = new CommentEntity();
        comment.setUserId(userId);
        comment.setType("comment");
        comment.setTime(ClockUtil.getCurrentTime());
        comment.setTaskId(this.taskId);
        comment.setProcessInstanceId(this.processInstanceId);
        comment.setAction("AddComment");
        ExecutionEntity execution = this.getExecution(commandContext);
        if (execution != null) {
            comment.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        }
        if (this.isHistoryRemovalTimeStrategyStart()) {
            this.provideRemovalTime(comment);
        }
        String eventMessage = comment.toEventMessage(this.message);
        comment.setMessage(eventMessage);
        comment.setFullMessage(this.message);
        commandContext.getCommentManager().insert(comment);
        TaskEntity task = this.getTask(commandContext);
        if (task != null) {
            task.triggerUpdateEvent();
        }
        return comment;
    }

    protected ExecutionEntity getExecution(CommandContext commandContext) {
        if (this.taskId != null) {
            TaskEntity task = this.getTask(commandContext);
            if (task != null) {
                return task.getExecution();
            }
            return null;
        }
        return this.getProcessInstance(commandContext);
    }

    protected ExecutionEntity getProcessInstance(CommandContext commandContext) {
        if (this.processInstanceId != null) {
            return commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        }
        return null;
    }

    protected TaskEntity getTask(CommandContext commandContext) {
        if (this.taskId != null) {
            return commandContext.getTaskManager().findTaskById(this.taskId);
        }
        return null;
    }

    protected boolean isHistoryRemovalTimeStrategyStart() {
        return "start".equals(this.getHistoryRemovalTimeStrategy());
    }

    protected String getHistoryRemovalTimeStrategy() {
        return Context.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected HistoricProcessInstanceEventEntity getHistoricRootProcessInstance(String rootProcessInstanceId) {
        return Context.getCommandContext().getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, rootProcessInstanceId);
    }

    protected void provideRemovalTime(CommentEntity comment) {
        HistoricProcessInstanceEventEntity historicRootProcessInstance;
        String rootProcessInstanceId = comment.getRootProcessInstanceId();
        if (rootProcessInstanceId != null && (historicRootProcessInstance = this.getHistoricRootProcessInstance(rootProcessInstanceId)) != null) {
            Date removalTime = historicRootProcessInstance.getRemovalTime();
            comment.setRemovalTime(removalTime);
        }
    }
}

