/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionVariableSnapshotObserver;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskManager;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.variable.VariableMap;
import java.io.Serializable;
import java.util.Map;

public class CompleteTaskCmd
implements Command<VariableMap>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Map<String, Object> variables;
    protected boolean returnVariables;
    protected boolean deserializeReturnedVariables;

    public CompleteTaskCmd(String taskId, Map<String, Object> variables) {
        this(taskId, variables, false, false);
    }

    public CompleteTaskCmd(String taskId, Map<String, Object> variables, boolean returnVariables, boolean deserializeReturnedVariables) {
        this.taskId = taskId;
        this.variables = variables;
        this.returnVariables = returnVariables;
        this.deserializeReturnedVariables = deserializeReturnedVariables;
    }

    @Override
    public VariableMap execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)task);
        this.checkCompleteTask(task, commandContext);
        if (this.variables != null) {
            task.setExecutionVariables(this.variables);
        }
        ExecutionEntity execution = task.getProcessInstance();
        ExecutionVariableSnapshotObserver variablesListener = null;
        if (this.returnVariables && execution != null) {
            variablesListener = new ExecutionVariableSnapshotObserver(execution, false, this.deserializeReturnedVariables);
        }
        this.completeTask(task);
        if (this.returnVariables) {
            if (variablesListener != null) {
                return variablesListener.getVariables();
            }
            return task.getCaseDefinitionId() != null ? null : task.getVariablesTyped(false);
        }
        return null;
    }

    protected void completeTask(TaskEntity task) {
        task.logUserOperation("Complete");
        task.complete();
    }

    protected void checkCompleteTask(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskWork(task);
        }
    }
}

