/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.MessageCorrelationBuilderImpl;
import io.openbpm.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.history.SynchronousOperationLogProducer;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.runtime.CorrelationHandler;
import io.openbpm.bpm.engine.impl.runtime.CorrelationHandlerResult;
import io.openbpm.bpm.engine.impl.runtime.CorrelationSet;
import io.openbpm.bpm.engine.impl.runtime.MessageCorrelationResultImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.runtime.ProcessInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CorrelateAllMessageCmd
extends AbstractCorrelateMessageCmd
implements Command<List<MessageCorrelationResultImpl>>,
SynchronousOperationLogProducer<MessageCorrelationResultImpl> {
    public CorrelateAllMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl, boolean collectVariables, boolean deserializeVariableValues) {
        super(messageCorrelationBuilderImpl, collectVariables, deserializeVariableValues);
    }

    @Override
    public List<MessageCorrelationResultImpl> execute(CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("At least one of the following correlation criteria has to be present: messageName, businessKey, correlationKeys, processInstanceId", this.messageName, this.builder.getBusinessKey(), this.builder.getCorrelationProcessInstanceVariables(), this.builder.getProcessInstanceId());
        CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        CorrelationSet correlationSet = new CorrelationSet(this.builder);
        List correlationResults = commandContext.runWithoutAuthorization(() -> correlationHandler.correlateMessages(commandContext, this.messageName, correlationSet));
        for (CorrelationHandlerResult correlationResult : correlationResults) {
            this.checkAuthorization(correlationResult);
        }
        ArrayList<MessageCorrelationResultImpl> results = new ArrayList<MessageCorrelationResultImpl>();
        for (CorrelationHandlerResult correlationResult : correlationResults) {
            results.add(this.createMessageCorrelationResult(commandContext, correlationResult));
        }
        this.produceOperationLog(commandContext, results);
        return results;
    }

    @Override
    public void createOperationLogEntry(CommandContext commandContext, MessageCorrelationResultImpl result, List<PropertyChange> propChanges, boolean isSummary) {
        String processInstanceId = null;
        String processDefinitionId = null;
        if (result.getProcessInstance() != null) {
            if (!isSummary) {
                processInstanceId = result.getProcessInstance().getId();
            }
            processDefinitionId = result.getProcessInstance().getProcessDefinitionId();
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation("CorrelateMessage", processInstanceId, processDefinitionId, null, propChanges);
    }

    @Override
    public Map<MessageCorrelationResultImpl, List<PropertyChange>> getPropChangesForOperation(List<MessageCorrelationResultImpl> results) {
        HashMap<MessageCorrelationResultImpl, List<PropertyChange>> resultPropChanges = new HashMap<MessageCorrelationResultImpl, List<PropertyChange>>();
        for (MessageCorrelationResultImpl messageCorrelationResultImpl : results) {
            List<PropertyChange> propChanges = this.getGenericPropChangesForOperation();
            ProcessInstance processInstance = messageCorrelationResultImpl.getProcessInstance();
            if (processInstance != null) {
                propChanges.add(new PropertyChange("processInstanceId", null, processInstance.getId()));
            }
            resultPropChanges.put(messageCorrelationResultImpl, propChanges);
        }
        return resultPropChanges;
    }

    @Override
    public List<PropertyChange> getSummarizingPropChangesForOperation(List<MessageCorrelationResultImpl> results) {
        List<PropertyChange> propChanges = this.getGenericPropChangesForOperation();
        propChanges.add(new PropertyChange("nrOfInstances", null, results.size()));
        return propChanges;
    }

    protected List<PropertyChange> getGenericPropChangesForOperation() {
        ArrayList<PropertyChange> propChanges = new ArrayList<PropertyChange>();
        propChanges.add(new PropertyChange("messageName", null, this.messageName));
        if (this.variablesCount > 0L) {
            propChanges.add(new PropertyChange("nrOfVariables", null, this.variablesCount));
        }
        return propChanges;
    }
}

