/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.MismatchingMessageCorrelationException;
import io.openbpm.bpm.engine.impl.MessageCorrelationBuilderImpl;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.runtime.CorrelationHandler;
import io.openbpm.bpm.engine.impl.runtime.CorrelationHandlerResult;
import io.openbpm.bpm.engine.impl.runtime.CorrelationSet;
import io.openbpm.bpm.engine.impl.runtime.MessageCorrelationResultImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.List;

public class CorrelateMessageCmd
extends AbstractCorrelateMessageCmd
implements Command<MessageCorrelationResultImpl> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected boolean startMessageOnly;

    public CorrelateMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl, boolean collectVariables, boolean deserializeVariableValues, boolean startMessageOnly) {
        super(messageCorrelationBuilderImpl, collectVariables, deserializeVariableValues);
        this.startMessageOnly = startMessageOnly;
    }

    @Override
    public MessageCorrelationResultImpl execute(CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("At least one of the following correlation criteria has to be present: messageName, businessKey, correlationKeys, processInstanceId", this.messageName, this.builder.getBusinessKey(), this.builder.getCorrelationProcessInstanceVariables(), this.builder.getProcessInstanceId());
        CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        CorrelationSet correlationSet = new CorrelationSet(this.builder);
        CorrelationHandlerResult correlationResult = null;
        if (this.startMessageOnly) {
            List correlationResults = commandContext.runWithoutAuthorization(() -> correlationHandler.correlateStartMessages(commandContext, this.messageName, correlationSet));
            if (correlationResults.isEmpty()) {
                throw new MismatchingMessageCorrelationException(this.messageName, "No process definition matches the parameters");
            }
            if (correlationResults.size() > 1) {
                throw LOG.exceptionCorrelateMessageToSingleProcessDefinition(this.messageName, correlationResults.size(), correlationSet);
            }
            correlationResult = (CorrelationHandlerResult)correlationResults.get(0);
        } else {
            correlationResult = commandContext.runWithoutAuthorization(() -> correlationHandler.correlateMessage(commandContext, this.messageName, correlationSet));
            if (correlationResult == null) {
                throw new MismatchingMessageCorrelationException(this.messageName, "No process definition or execution matches the parameters");
            }
        }
        this.checkAuthorization(correlationResult);
        return this.createMessageCorrelationResult(commandContext, correlationResult);
    }
}

