/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.entitymanager.DbEntityManager;
import io.openbpm.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.AttachmentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.impl.util.IoUtil;
import io.openbpm.bpm.engine.repository.ResourceTypes;
import io.openbpm.bpm.engine.task.Attachment;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class CreateAttachmentCmd
implements Command<Attachment> {
    protected String taskId;
    protected String attachmentType;
    protected String processInstanceId;
    protected String attachmentName;
    protected String attachmentDescription;
    protected InputStream content;
    protected String url;
    private TaskEntity task;
    protected ExecutionEntity processInstance;

    public CreateAttachmentCmd(String attachmentType, String taskId, String processInstanceId, String attachmentName, String attachmentDescription, InputStream content, String url) {
        this.attachmentType = attachmentType;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.attachmentName = attachmentName;
        this.attachmentDescription = attachmentDescription;
        this.content = content;
        this.url = url;
    }

    @Override
    public Attachment execute(CommandContext commandContext) {
        if (this.taskId != null) {
            this.task = commandContext.getTaskManager().findTaskById(this.taskId);
        } else {
            EnsureUtil.ensureNotNull("taskId or processInstanceId has to be provided", (Object)this.processInstanceId);
            List<ExecutionEntity> executionsByProcessInstanceId = commandContext.getExecutionManager().findExecutionsByProcessInstanceId(this.processInstanceId);
            this.processInstance = executionsByProcessInstanceId.get(0);
        }
        AttachmentEntity attachment = new AttachmentEntity();
        attachment.setName(this.attachmentName);
        attachment.setDescription(this.attachmentDescription);
        attachment.setType(this.attachmentType);
        attachment.setTaskId(this.taskId);
        attachment.setProcessInstanceId(this.processInstanceId);
        attachment.setUrl(this.url);
        attachment.setCreateTime(ClockUtil.getCurrentTime());
        if (this.task != null) {
            ExecutionEntity execution = this.task.getExecution();
            if (execution != null) {
                attachment.setRootProcessInstanceId(execution.getRootProcessInstanceId());
            }
        } else if (this.processInstance != null) {
            attachment.setRootProcessInstanceId(this.processInstance.getRootProcessInstanceId());
        }
        if (this.isHistoryRemovalTimeStrategyStart()) {
            this.provideRemovalTime(attachment);
        }
        DbEntityManager dbEntityManger = commandContext.getDbEntityManager();
        dbEntityManger.insert(attachment);
        if (this.content != null) {
            byte[] bytes = IoUtil.readInputStream(this.content, this.attachmentName);
            ByteArrayEntity byteArray = new ByteArrayEntity(bytes, ResourceTypes.HISTORY);
            byteArray.setRootProcessInstanceId(attachment.getRootProcessInstanceId());
            byteArray.setRemovalTime(attachment.getRemovalTime());
            commandContext.getByteArrayManager().insertByteArray(byteArray);
            attachment.setContentId(byteArray.getId());
        }
        PropertyChange propertyChange = new PropertyChange("name", null, this.attachmentName);
        if (this.task != null) {
            commandContext.getOperationLogManager().logAttachmentOperation("AddAttachment", this.task, propertyChange);
            this.task.triggerUpdateEvent();
        } else if (this.processInstance != null) {
            commandContext.getOperationLogManager().logAttachmentOperation("AddAttachment", this.processInstance, propertyChange);
        }
        return attachment;
    }

    protected boolean isHistoryRemovalTimeStrategyStart() {
        return "start".equals(this.getHistoryRemovalTimeStrategy());
    }

    protected String getHistoryRemovalTimeStrategy() {
        return Context.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected HistoricProcessInstanceEventEntity getHistoricRootProcessInstance(String rootProcessInstanceId) {
        return Context.getCommandContext().getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, rootProcessInstanceId);
    }

    protected void provideRemovalTime(AttachmentEntity attachment) {
        HistoricProcessInstanceEventEntity historicRootProcessInstance;
        String rootProcessInstanceId = attachment.getRootProcessInstanceId();
        if (rootProcessInstanceId != null && (historicRootProcessInstance = this.getHistoricRootProcessInstance(rootProcessInstanceId)) != null) {
            Date removalTime = historicRootProcessInstance.getRemovalTime();
            attachment.setRemovalTime(removalTime);
        }
    }
}

