/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cmd.AbstractWritableIdentityServiceCmd;
import io.openbpm.bpm.engine.impl.identity.IdentityOperationResult;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class CreateTenantGroupMembershipCmd
extends AbstractWritableIdentityServiceCmd<Void>
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String tenantId;
    protected final String groupId;

    public CreateTenantGroupMembershipCmd(String tenantId, String groupId) {
        this.tenantId = tenantId;
        this.groupId = groupId;
    }

    @Override
    protected Void executeCmd(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("tenantId", (Object)this.tenantId);
        EnsureUtil.ensureNotNull("groupId", (Object)this.groupId);
        IdentityOperationResult operationResult = commandContext.getWritableIdentityProvider().createTenantGroupMembership(this.tenantId, this.groupId);
        commandContext.getOperationLogManager().logMembershipOperation(operationResult, null, this.groupId, this.tenantId);
        return null;
    }
}

