/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.cmd.AbstractWritableIdentityServiceCmd;
import io.openbpm.bpm.engine.impl.identity.IdentityOperationResult;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;

public class CreateTenantUserMembershipCmd
extends AbstractWritableIdentityServiceCmd<Void>
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String tenantId;
    protected final String userId;

    public CreateTenantUserMembershipCmd(String tenantId, String userId) {
        this.tenantId = tenantId;
        this.userId = userId;
    }

    @Override
    protected Void executeCmd(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("tenantId", (Object)this.tenantId);
        EnsureUtil.ensureNotNull("userId", (Object)this.userId);
        IdentityOperationResult operationResult = commandContext.getWritableIdentityProvider().createTenantUserMembership(this.tenantId, this.userId);
        commandContext.getOperationLogManager().logMembershipOperation(operationResult, this.userId, null, this.tenantId);
        return null;
    }
}

