/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.engine.impl.AuthorizationQueryImpl;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.AuthorizationManager;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class DeleteAuthorizationCmd
implements Command<Void> {
    protected String authorizationId;

    public DeleteAuthorizationCmd(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        AuthorizationEntity authorization = (AuthorizationEntity)new AuthorizationQueryImpl().authorizationId(this.authorizationId).singleResult();
        EnsureUtil.ensureNotNull("Authorization for Id '" + this.authorizationId + "' does not exist", "authorization", (Object)authorization);
        authorizationManager.delete(authorization);
        commandContext.getOperationLogManager().logAuthorizationOperation("Delete", authorization, null);
        return null;
    }
}

