/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.cmd;

import io.openbpm.bpm.application.ProcessApplicationReference;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.CommandChecker;
import io.openbpm.bpm.engine.impl.cfg.TransactionLogger;
import io.openbpm.bpm.engine.impl.cfg.TransactionState;
import io.openbpm.bpm.engine.impl.cmd.UnregisterDeploymentCmd;
import io.openbpm.bpm.engine.impl.cmd.UnregisterProcessApplicationCmd;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.DeleteDeploymentFailListener;
import io.openbpm.bpm.engine.impl.persistence.entity.DeploymentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.PropertyChange;
import io.openbpm.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DeleteDeploymentCmd
implements Command<Void>,
Serializable {
    private static final TransactionLogger TX_LOG = ProcessEngineLogger.TX_LOGGER;
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected boolean cascade;
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;

    public DeleteDeploymentCmd(String deploymentId, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        this.deploymentId = deploymentId;
        this.cascade = cascade;
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMappings = skipIoMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)this.deploymentId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteDeployment(this.deploymentId);
        }
        UserOperationLogManager logManager = commandContext.getOperationLogManager();
        List<PropertyChange> propertyChanges = Arrays.asList(new PropertyChange("cascade", null, this.cascade));
        DeploymentEntity deployment = commandContext.getDeploymentManager().findDeploymentById(this.deploymentId);
        String tenantId = deployment != null ? deployment.getTenantId() : null;
        logManager.logDeploymentOperation("Delete", this.deploymentId, tenantId, propertyChanges);
        commandContext.getDeploymentManager().deleteDeployment(this.deploymentId, this.cascade, this.skipCustomListeners, this.skipIoMappings);
        ProcessApplicationReference processApplicationReference = Context.getProcessEngineConfiguration().getProcessApplicationManager().getProcessApplicationForDeployment(this.deploymentId);
        DeleteDeploymentFailListener listener = new DeleteDeploymentFailListener(this.deploymentId, processApplicationReference, Context.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew());
        try {
            commandContext.runWithoutAuthorization(new UnregisterProcessApplicationCmd(this.deploymentId, false));
            commandContext.runWithoutAuthorization(new UnregisterDeploymentCmd(Collections.singleton(this.deploymentId)));
        }
        finally {
            try {
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
            }
            catch (Exception e) {
                TX_LOG.debugTransactionOperation("Could not register transaction synchronization. Probably the TX has already been rolled back by application code.");
                listener.execute(commandContext);
            }
        }
        return null;
    }
}

